package cn.com.duiba.thirdpartyvnew.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.AlipayOfficialRequestDto;
import cn.com.duiba.thirdpartyvnew.dto.SupplierRequestDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 提交直充类接口请求
 */
@AdvancedFeignClient
public interface RemoteChargeService {

	/**
	 * 提交官方支付宝接口请求<br/>
	 * 1.将请求丢到批次请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 
	 * @param request
	 * @return
	 */
	public DubboResult<Boolean> submitAlipay(AlipayOfficialRequestDto request);

	/**
	 * @deprecated
	 * 提交众想支付宝接口请求 <br/>
	 * 1.将请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 callbackTopic队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param supplierRequestDto
	 * @param callbackTopic
	 * @return
	 */
	@Deprecated
	@RequestMapping("deprecatedSubmitZxAlipay")
	public DubboResult<Boolean> submitZxAlipay(SupplierRequestDto supplierRequestDto, String callbackTopic);

	/**
	 * @deprecated
	 * 提交QB第三方接口请求请求<br/>
	 * 1.将请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 callbackTopic队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param supplierRequestDto
	 * @param callbackTopic
	 * @return
	 */
	@Deprecated
	@RequestMapping("deprecatedSubmitQb")
	public DubboResult<Boolean> submitQb(SupplierRequestDto supplierRequestDto, String callbackTopic);

	/**
	 * @deprecated
	 * 提交话费第三方接口请求<br/>
	 * 1.将请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 callbackTopic队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param supplierRequestDto
 	 * @param callbackTopic
	 * @return
	 */
	@Deprecated
	@RequestMapping("deprecatedSubmitPhonebill")
	public DubboResult<Boolean> submitPhonebill(SupplierRequestDto supplierRequestDto, String callbackTopic);
	
	/**
	 * @deprecated
	 * 提交流量第三方接口请求<br/>
	 * 1.将请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 callbackTopic队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param supplierRequestDto
 	 * @param callbackTopic
	 * @return
	 */
	@Deprecated
	@RequestMapping("deprecatedSubmitPhoneflow")
	public DubboResult<Boolean> submitPhoneflow(SupplierRequestDto supplierRequestDto, String callbackTopic);


	/**
	 * @deprecated
	 * 提交虚拟商品第三方接口<br/>
	 * 1.将请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 callbackTopic队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param supplierRequestDto
 	 * @param callbackTopic
	 * @return
	 */
	@Deprecated
	@RequestMapping("deprecatedSubmitVirtual")
	public DubboResult<Boolean> submitVirtual(SupplierRequestDto supplierRequestDto, String callbackTopic);
	
	
	/**
	 * 提交众想支付宝接口请求 <br/>
	 * 1.将请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 ONS队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param supplierRequestDto
	 * @param callbackTopic  队列名称
	 * @param tag  消息标签
	 * @param key 非必填项
	 * @return
	 */
	public DubboResult<Boolean> submitZxAlipay(SupplierRequestDto supplierRequestDto, String callbackTopic, String tag, String key);
	
	/**
	 * 提交QB第三方接口请求请求<br/>
	 * 1.将请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 ONS队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param supplierRequestDto
	 * @param callbackTopic  队列名称
	 * @param tag  消息标签
	 * @param key 非必填项
	 * @return
	 */
	public DubboResult<Boolean> submitQb(SupplierRequestDto supplierRequestDto, String callbackTopic, String tag, String key);


	/**
	 * 提交话费第三方接口请求<br/>
	 * 1.将请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 ons队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * @param supplierRequestDto
	 * @param callbackTopic  队列名称
	 * @param tag  消息标签
	 * @param key 非必填项
	 * @return
	 */
	public DubboResult<Boolean> submitPhonebill(SupplierRequestDto supplierRequestDto, String callbackTopic, String tag, String key);
	
	
	/**
	 * 提交流量第三方接口请求<br/>
	 * 1.将请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 callbackTopic队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param supplierRequestDto
	 * @param callbackTopic  队列名称
	 * @param tag  消息标签
	 * @param key 非必填项
	 * @return
	 */
	public DubboResult<Boolean> submitPhoneflow(SupplierRequestDto supplierRequestDto, String callbackTopic, String tag, String key);
	
	/**
	 * 提交虚拟商品第三方接口<br/>
	 * 1.将请求丢到HTTP请求池中<br/>
	 * 2.返回Boolean是否提交成功<br/>
	 * 3.HTTP异步处理完后会把响应结果发送到 callbackTopic队列中<br/>
	 * 4.业务放订阅callbackTopic队列进行后续流程<br/>
	 * 
	 * @param supplierRequestDto
	 * @param callbackTopic  队列名称
	 * @param tag  消息标签
	 * @param key 非必填项
	 * @return
	 */
	public DubboResult<Boolean> submitVirtual(SupplierRequestDto supplierRequestDto, String callbackTopic, String tag, String key);

	/**
	 * 手动补发奖品用，不依赖于兑吧
	 * 提交虚拟商品第三方接口<br/>
	 * 返回Boolean是否提交成功<br/>
	 *
	 * @param supplierRequestDto
	 * @return
	 */
	DubboResult<String> submitVirtualSync(SupplierRequestDto supplierRequestDto);

}
