package cn.com.duiba.thirdpartyvnew.api.logistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.logistics.AutoNumResponse;
import cn.com.duiba.thirdpartyvnew.dto.logistics.SubscribeRequestParam;
import cn.com.duiba.thirdpartyvnew.dto.logistics.SubscribeResponse;

/**
 * @author lyj
 * 采购物流信息订阅
 */
@AdvancedFeignClient
public interface RemoteLogisticsSubscribeService {

    /**
     * 订阅物流信息
     * @param subscribeRequestParam 订阅消息
     * @return 订阅结果
     */
    SubscribeResponse pushSubscribeMessage(SubscribeRequestParam subscribeRequestParam);

    /**
     * 查询物流公司
     * @param logisticNo 物流单号
     * @return 物流公司信息
     */
    AutoNumResponse queryLogisticsCompany(String logisticNo);

}
