package cn.com.duiba.thirdpartyvnew.util.nmggs;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * 
 * @ClassName:SecurityUtils
 * @Description:安全工具类
 * @author ZHAOBO
 * @修改时间：2016年5月13日 上午10:29:41
 * @修改内容：创建
 */
public interface SecurityUtils {

	/**
	 * 
	 * @Title:byteArrayToHex
	 * @Description:转换MD5或SHA1字节数组为字符串
	 * @param byteArray
	 * @return
	 * @author ZHAOBO
	 * @修改时间：2016年5月13日 上午10:41:59
	 * @修改内容：创建
	 */
	static String byteArrayToHex(byte[] byteArray) {

		// 首先初始化一个字符数组，用来存放每个16进制字符
		char[] hexDigits = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };
		// new一个字符数组，这个就是用来组成结果字符串的（解释一下：一个byte是八位二进制，也就是2位十六进制字符（2的8次方等于16的2次方））
		char[] resultCharArray = new char[byteArray.length * 2];
		// 遍历字节数组，通过位运算（位运算效率高），转换成字符放到字符数组中去
		int index = 0;
		for (byte b : byteArray) {
			resultCharArray[index++] = hexDigits[b >>> 4 & 0xf];
			resultCharArray[index++] = hexDigits[b & 0xf];
		}
		// 字符数组组合成字符串返回
		return new String(resultCharArray);
	}

	/**
	 * 
	 * @Title:MD5
	 * @Description:根据字符串生成MD5
	 * @param str
	 * @return
	 * @author ZHAOBO
	 * @throws NoSuchAlgorithmException
	 * @修改时间：2016年5月13日 上午10:42:23
	 * @修改内容：创建
	 */
	static String MD5(String str) throws NoSuchAlgorithmException {
		// 拿到一个MD5转换器（同样，这里可以换成SHA1）
		MessageDigest messageDigest = MessageDigest.getInstance("MD5");
		// 拿到结果，也是字节数组，包含16个元素
		byte[] resultByteArray = messageDigest.digest(str.getBytes());
		// 同样，把字节数组转换成字符串
		return byteArrayToHex(resultByteArray);

	}

	/**
	 * 
	 * @Title:SHA1
	 * @Description:根据字符串生成SHA1
	 * @param str
	 * @return
	 * @author ZHAOBO
	 * @throws NoSuchAlgorithmException
	 * @修改时间：2016年5月13日 上午10:42:47
	 * @修改内容：创建
	 */
	static String SHA1(String str) throws NoSuchAlgorithmException {
		// 拿到一个SHA1转换器（同样，这里可以换成MD5）
		MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
		// 拿到结果，也是字节数组
		byte[] resultByteArray = messageDigest.digest(str.getBytes());
		// 同样，把字节数组转换成字符串
		return byteArrayToHex(resultByteArray);

	}

	public static void main(String[] args) throws Exception{
		System.out.println(MD5("redirect_uri=http://127.0.0.1:9001/example-app/web/oauth2/receiveAuthorizeCodeSysTest&appid=8665BDADA50B0561E053780A120AFA59&salt=1111qqqq"));
	}
}
