package cn.com.duiba.thirdpartyvnew.dto.wanda.response;

import lombok.Data;

import java.io.Serializable;
@Data
public class WandaQueryInvoiceResponseData implements Serializable {
    /**
     * 发票请求流水号
     */
    private String serialNo;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 发票状态： 2 :开票完成（ 最终状 态），其他状态
     * 分别为: 20:开票中; 21:开票成功签章中;22:开票失
     * 败;24: 开票成功签章失败;3:发票已作废 31: 发票作
     * 废中 备注：22、24状态时，无需再查询，请确认
     * 开票失败原因以及签章失败原因； 注：请以该状
     * 态码区分发票状态
     */
    private String status;

    /**
     * 发票状态描述
     */
    private String statusMsg;

    /**
     * 失败原因
     */
    private String failCause;

    /**
     * 发票pdf地址（若同时返回了ofdUrl与pdfUrl，则
     * pdf文件不能做为原始凭证，请用ofd文件做为原
     * 始凭证）
     */
    private String pdfUrl;

    /**
     * 发票ofd地址（公共服务平台签章及数电电票时返
     * 回）
     */
    private String ofdUrl;

    /**
     * 发票号
     */
    private String allElectronicInvoiceNumber;
}
