package cn.com.duiba.thirdpartyvnew.api.jincheng;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.AddScoreReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.AddScoreRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.GetTokenReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.GetTokenRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.GoodsLimitQueryReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.GoodsLimitQueryRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.OrderApplyReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.OrderApplyRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.OrderExchangeReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.OrderExchangeRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.PreOrderConfirmReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.PreOrderConfirmRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.PurchaseCallbackRequest;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.PurchaseCallbackResponse;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.PushOrderReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.PushOrderRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.QueryOrderResultReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.QueryOrderResultRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.QueryUserScoreReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.QueryUserScoreRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.RecordInfoReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.RecordInfoRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.SendOrderSmsReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.SendOrderSmsRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.SubmitOrderSmsReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.SubmitOrderSmsRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.TokenCheckReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.TokenCheckRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.top.JinchengCommonDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 金城银行-外部接口调用
 *
 * @author songp
 * @date 2024/5/22 6:17 下午
 */
@AdvancedFeignClient
public interface RemoteJinChengService {

    /**
     * 获取token
     *
     * @param reqDto 请求参数
     * @return 响应
     */
    DubboResult<GetTokenRespDto> getToken(GetTokenReqDto reqDto);

    /**
     * token校验与续期
     *
     * @param reqDto 请求参数
     * @return 响应
     */
    DubboResult<TokenCheckRespDto> tokenCheck(TokenCheckReqDto reqDto);

    /**
     * 商品预下单接口
     *
     * @param reqDto 请求参数
     * @return 响应
     */
    DubboResult<PreOrderConfirmRespDto> preOrderConfirm(PreOrderConfirmReqDto reqDto);

    /**
     * 发送短信验证码
     *
     * @param reqDto 请求参数
     * @return 响应
     */
    DubboResult<SendOrderSmsRespDto> sendOrderSms(SendOrderSmsReqDto reqDto);

    /**
     * 提交短信验证码
     *
     * @param reqDto 请求参数
     * @return 响应
     */
    DubboResult<SubmitOrderSmsRespDto> submitOrderSms(SubmitOrderSmsReqDto reqDto);

    /**
     * 商品下单申请
     *
     * @param reqDto 请求参数
     * @return 响应
     */
    DubboResult<OrderApplyRespDto> orderApply(OrderApplyReqDto reqDto);

    /**
     * 查询用户积分
     *
     * @param reqDto 请求参数
     * @return 响应
     */
    DubboResult<QueryUserScoreRespDto> queryUserScore(QueryUserScoreReqDto reqDto);

    /**
     * 发起金城商品兑换
     *
     * @param reqDto 请求参数
     * @return 响应
     */
    DubboResult<OrderExchangeRespDto> orderExchange(OrderExchangeReqDto reqDto);

    /**
     * 金城订单兑换结果查询
     *
     * @param reqDto 请求参数
     * @return 响应
     */
    DubboResult<QueryOrderResultRespDto> queryOrderResult(QueryOrderResultReqDto reqDto);

    /**
     * 加积分接口
     *
     * @param reqDto 请求参数
     * @return 响应
     */
    DubboResult<AddScoreRespDto> addScore(AddScoreReqDto reqDto);

    /**
     * 兑吧订单推送接口
     *
     * @param reqDto 请求参数
     * @return 响应
     */
    DubboResult<PushOrderRespDto> pushOrder(PushOrderReqDto reqDto);

    /**
     * 兑换记录同步接口
     *
     * @param reqDto 请求参数
     * @return 响应
     */
    DubboResult<RecordInfoRespDto> recordInfo(RecordInfoReqDto reqDto);

    /**
     *采购订单回调
     * @param request  请求参数
     * @return 响应
     * @throws BizException 业务异常
     */
    DubboResult<PurchaseCallbackResponse> purchaseCallback(PurchaseCallbackRequest request) throws BizException;

    /**
     * 商品限购查询
     * @param reqDto 请求参数
     * @return 响应
     * @throws BizException 业务异常
     */
    DubboResult<GoodsLimitQueryRespDto> goodsLimitQuery(GoodsLimitQueryReqDto reqDto) throws BizException;

    /**
     * 验签名并解析响应结果
     *
     * @param resp 响应内容
     * @return 返回值
     * @throws BizException biz exception
     */
    String verifyAndDecrypt(String resp) throws BizException;

    /**
     * encrypt
     *
     * @param body       body
     * @param sequenceNo sequence no
     * @return {@link JinchengCommonDto }
     */
    JinchengCommonDto encrypt(String body, String sequenceNo) throws BizException;

    /**
     * temp save verify id
     *
     * @param orderNum order num
     * @param verifyId verify id
     * @return boolean
     */
    boolean tempSaveVerifyId(String orderNum, String verifyId);

    /**
     * get verify id
     *
     * @param orderNum order num
     * @return {@link String }
     */
    String getVerifyId(String orderNum);

}
