package cn.com.duiba.thirdpartyvnew.api.lshm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.lshm.request.LshmBackCreditsRequest;
import cn.com.duiba.thirdpartyvnew.dto.lshm.request.LshmDeductCreditsRequest;
import cn.com.duiba.thirdpartyvnew.dto.lshm.request.LshmDisableCouponRequest;
import cn.com.duiba.thirdpartyvnew.dto.lshm.request.LshmIncrementCreditsRequest;
import cn.com.duiba.thirdpartyvnew.dto.lshm.request.LshmQueryCouponRequest;
import cn.com.duiba.thirdpartyvnew.dto.lshm.request.LshmSendCouponRequest;
import cn.com.duiba.thirdpartyvnew.dto.lshm.request.LshmShopQueryRequest;
import cn.com.duiba.thirdpartyvnew.dto.lshm.request.LshmUserInfoQueryRequest;
import cn.com.duiba.thirdpartyvnew.dto.lshm.response.LshmBaseResponse;
import cn.com.duiba.thirdpartyvnew.dto.lshm.response.LshmDeductCreditsResponseData;
import cn.com.duiba.thirdpartyvnew.dto.lshm.response.LshmDisableCouponResponseData;
import cn.com.duiba.thirdpartyvnew.dto.lshm.response.LshmQueryCouponResponseData;
import cn.com.duiba.thirdpartyvnew.dto.lshm.response.LshmSendCouponResponseData;
import cn.com.duiba.thirdpartyvnew.dto.lshm.response.LshmUserInfoQueryResponseData;

@AdvancedFeignClient
public interface RemoteLshmService {
    /**
     * 扣除积分
     *
     * @param request 扣除积分请求
     * @return 扣除积分响应
     */
    LshmBaseResponse<LshmDeductCreditsResponseData> deductCredits(LshmDeductCreditsRequest request);

    /**
     * 增加积分
     *
     * @param request 增加积分请求
     * @return 增加积分响应
     */
    LshmBaseResponse<Boolean> incrementCredits(LshmIncrementCreditsRequest request);

    /**
     * 回滚积分
     *
     * @param request 回滚积分请求
     * @return 基础响应
     */
    LshmBaseResponse<Boolean> backCredits(LshmBackCreditsRequest request);

    /**
     * 发放优惠券
     *
     * @param request 发放优惠券请求
     * @return 发放优惠券响应
     */
    LshmBaseResponse<LshmSendCouponResponseData> sendCoupon(LshmSendCouponRequest request);

    /**
     * 优惠券查询
     *
     * @param request 优惠券查询请求
     * @return 优惠券查询响应
     */
    LshmBaseResponse<LshmQueryCouponResponseData> queryCoupon(LshmQueryCouponRequest request);

    /**
     * 优惠券作废
     *
     * @param request 优惠券作废请求
     * @return 优惠券作废响应
     */
    LshmBaseResponse<LshmDisableCouponResponseData> disableCoupon(LshmDisableCouponRequest request);

    /**
     * 门店查询
     *
     * @param request 门店券查询请求
     * @return 门店查询响应
     */
    LshmBaseResponse<LshmShopQueryRequest> shopQuery(LshmShopQueryRequest request);

    /**
     * 用户信息查询
     * @param request 用户信息查询请求
     * @return 用户信息查询响应
     */
    LshmBaseResponse<LshmUserInfoQueryResponseData> userInfoQuery(LshmUserInfoQueryRequest request);
}
