package cn.com.duiba.thirdpartyvnew.dto.jinke.response;

import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.List;

/**
 * 金科合作机构列表查询响应
 *
 * @author system
 * @date 2024/12/19
 */
public class MerchantQueryResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 业务结果
     */
    private List<MerchantInfo> result;

    /**
     * 页码
     */
    private Integer page;

    /**
     * 每页记录数
     */
    @JSONField(name = "page_size")
    private Integer pageSize;

    /**
     * 总数
     */
    private Integer total;

    public List<MerchantInfo> getResult() {
        return result;
    }

    public void setResult(List<MerchantInfo> result) {
        this.result = result;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    /**
     * 合作机构信息
     */
    public static class MerchantInfo implements Serializable {
        private static final long serialVersionUID = 1L;

        /**
         * 合作机构编号
         */
        @JSONField(name = "access_merchant_code")
        private String accessMerchantCode;

        /**
         * 合作机构名
         */
        @JSONField(name = "access_merchant_name")
        private String accessMerchantName;

        public String getAccessMerchantCode() {
            return accessMerchantCode;
        }

        public void setAccessMerchantCode(String accessMerchantCode) {
            this.accessMerchantCode = accessMerchantCode;
        }

        public String getAccessMerchantName() {
            return accessMerchantName;
        }

        public void setAccessMerchantName(String accessMerchantName) {
            this.accessMerchantName = accessMerchantName;
        }
    }
}