package cn.com.duiba.thirdpartyvnew.dto.lzlj.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 泸州老窖扣积分请求数据
 * 根据泸州老窖积分扣减接口文档设计
 */
@Data
public class LzljDeductCreditsRequestData implements Serializable {
    private static final long serialVersionUID = 1L;
    
    /**
     * 用户唯一性标识，唯一且不可变（必填）
     * 限制长度：255
     */
    private String uid;
    
    /**
     * 本次兑换扣除的积分（必填）
     * 限制长度：20
     */
    private Long credits;
    
    /**
     * 自有商品商品编码（非必须字段）
     * 限制长度：255
     */
    private String itemCode;
    
    /**
     * 接口appKey，应用的唯一标识（必填）
     * 限制长度：255
     */
    private String appKey;
    
    /**
     * 1970-01-01开始的时间戳，毫秒为单位（必填）
     * 限制长度：20
     */
    private String timestamp;
    
    /**
     * 本次积分消耗的描述，带中文，请用utf-8进行url解码（必填）
     * 限制长度：255
     */
    private String description;
    
    /**
     * 兑吧订单号，请记录到数据库中（必填）
     * 限制长度：255
     */
    private String orderNum;
    
    /**
     * 兑换类型（必填）
     * 限制长度：255
     * 可选值：alipay(支付宝), qb(Q币), coupon(优惠券), object(实物), phonebill(话费), phoneflow(流量), virtual(虚拟商品),game(游戏), hdtool(活动抽奖),sign(签到)
     * 所有类型不区分大小写
     */
    private String type;
    
    /**
     * 兑换商品的市场价值，单位是分，请自行转换单位（非必须）
     * 限制长度：11
     */
    private Integer facePrice;
    
    /**
     * 此次兑换实际扣除开发者账户费用，单位为分（必填）
     * 限制长度：11
     */
    private Integer actualPrice;
    
    /**
     * 用户ip，不保证获取到（非必须）
     * 限制长度：255
     */
    private String ip;
    
    /**
     * 直冲商品Q币商品，QQ号码回传参数，其他商品不传该参数（非必须）
     * 限制长度：255
     */
    private String qq;
    
    /**
     * 直冲类话费商品手机号回传参数，非话费商品不传该参数（非必须）
     * 限制长度：255
     */
    private String phone;
    
    /**
     * 支付宝充值商品支付宝账号参数回传，非支付宝商品不传该参数（非必须）
     * 限制长度：255
     */
    private String alipay;
    
    /**
     * 是否需要审核，如需在自身系统进行审核处理，请记录下此信息（非必须）
     */
    private Boolean waitAudit;
    
    /**
     * 详情参数，不同的类型，请求时传不同的内容，中间用英文冒号分隔（非必须）
     * 限制长度：255
     * 支付宝类型带中文，请用utf-8进行解码
     * 实物商品：返回收货信息(姓名:手机号:省份:城市:区域:街道:详细地址)
     * 支付宝：返回账号信息(支付宝账号:实名)
     * 话费：返回手机号
     * QB：返回QQ号
     */
    private String params;
    

}