package cn.com.duiba.thirdpartyvnew.dto.wanda.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 万达获取会员优惠券请求DTO
 *
 * @author zhangdaqing
 * @date 2025/7/10
 */
@Data
public class WandaCouponQueryRequest implements Serializable {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 会员手机号（可选）
     */
    private String mobile;
    
    /**
     * 会员id（可选）
     */
    private String memberId;
    
    /**
     * 会员卡号（可选）
     */
    private String cardNo;
    
    /**
     * 券状态（可选）
     * E未使用 C已使用 G已赠送 T已过期 V已作废 U 赠送中
     */
    private String status;
    
    /**
     * 分页页码（必填）
     */
    private Integer page;
    
    /**
     * 每页条数（必填）
     */
    private Integer size;
    
    /**
     * 创建获取会员优惠券请求
     * 
     * @param page 分页页码
     * @param size 每页条数
     * @return WandaCouponQueryRequest
     */
    public static WandaCouponQueryRequest create(Integer page, Integer size) {
        WandaCouponQueryRequest request = new WandaCouponQueryRequest();
        request.setPage(page);
        request.setSize(size);
        return request;
    }
    
    /**
     * 创建获取会员优惠券请求（带会员信息）
     * 
     * @param page 分页页码
     * @param size 每页条数
     * @param memberId 会员id
     * @param cardNo 会员卡号
     * @return WandaCouponQueryRequest
     */
    public static WandaCouponQueryRequest createWithMember(Integer page, Integer size, 
                                                          String memberId, String cardNo) {
        WandaCouponQueryRequest request = new WandaCouponQueryRequest();
        request.setPage(page);
        request.setSize(size);
        request.setMemberId(memberId);
        request.setCardNo(cardNo);
        return request;
    }
    
    /**
     * 验证必填字段
     */
    public void validate() {
        if (page == null || page <= 0) {
            throw new IllegalArgumentException("分页页码必须大于0");
        }
        if (size == null || size <= 0) {
            throw new IllegalArgumentException("每页条数必须大于0");
        }
        if (size > 10000) {
            throw new IllegalArgumentException("每页条数不能超过10000");
        }
    }
} 