package cn.com.duiba.thirdpartyvnew.api.jinke;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.jinke.request.MerchantQueryParam;
import cn.com.duiba.thirdpartyvnew.dto.jinke.request.MerchantAssetsQueryParam;
import cn.com.duiba.thirdpartyvnew.dto.jinke.response.MerchantQueryResponse;
import cn.com.duiba.thirdpartyvnew.dto.jinke.response.MerchantAssetsQueryResponse;
import cn.com.duiba.thirdpartyvnew.dto.kongquechneg.MemberDto;

/**
 * 金科外部接口调用
 *
 * @author wgh
 */
@AdvancedFeignClient
public interface RemoteJinKeService {

    /**
     * 金科发送post请求
     */
    <T> String sendJinkePost(String merchant_code, String url, String encryptAppId, T param);

    /**
     * 金科发送get请求
     */
    String sendJinkeGet(String merchant_code, String url, String encryptAppId, String params);

    /**
     * 合作机构列表查询接口
     * @param merchantCode 商户号
     * @param page 页码
     * @param pageSize 每页记录数
     * @return 合作机构列表查询结果
     */
    MerchantQueryResponse queryMerchantList(String merchantCode, Integer page, Integer pageSize);

    /**
     * 资源列表查询接口
     * @param merchantCode 商户号
     * @return 资源列表查询结果
     */
    MerchantAssetsQueryResponse queryMerchantAssets(String merchantCode);

}
