package cn.com.duiba.thirdpartyvnew.dto.hsbc;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2022/7/6 上午10:16
 */
public class HsbcNewsDto implements Serializable {
    private static final long serialVersionUID = -7408002284465167143L;

    /** 资讯id */
    private Long itemId;

    /** 资讯类型，NEWS-文章；VIDEO-视频；AUDIO-音频 */
    private String itemType;

    /** 资讯子类别 */
    private String itemSubType;

    /** 供应商code */
    private String supplierCode;

    /** 供应商名称 */
    private String supplierName;

    /** 供应商权重 */
    private Double supplierWeight;

    /** 资讯来源 */
    private String source;

    /** 来源code */
    private String sourceCode;

    /** 来源名称 */
    private String sourceName;

    /** 来源权重 */
    private Double sourceWeight;

    /** 标题 */
    private String title;

    /** 内容 */
    private String content;

    /** 标题长度 */
    private Integer lengthTitle;

    /** 正文长度 */
    private Integer lengthContent;

    /** 发布时间 */
    private Date publishTime;

    /** 创建时间 */
    private Date createdTime;

    /** 创建人 */
    private String createdBy;

    /** 更新人 */
    private String updatedBy;

    /** 状态；NORMAL-正常；DISABLED-下架 */
    private String status;

    /** 输入服务信息 */
    private String[] serviceCodes;

    /** 输出栏目信息 */
    private String[] columns;

    /** 标准栏目 */
    private String[] stdColumns;

    /**  供应商头像==来源icon */
    private String supplierImg;

    /** 智能配图 */
    private List<Imgs> imgs;

    /** 扩展信息 */
    private Extend extend;

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemSubType() {
        return itemSubType;
    }

    public void setItemSubType(String itemSubType) {
        this.itemSubType = itemSubType;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Double getSupplierWeight() {
        return supplierWeight;
    }

    public void setSupplierWeight(Double supplierWeight) {
        this.supplierWeight = supplierWeight;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Double getSourceWeight() {
        return sourceWeight;
    }

    public void setSourceWeight(Double sourceWeight) {
        this.sourceWeight = sourceWeight;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getLengthTitle() {
        return lengthTitle;
    }

    public void setLengthTitle(Integer lengthTitle) {
        this.lengthTitle = lengthTitle;
    }

    public Integer getLengthContent() {
        return lengthContent;
    }

    public void setLengthContent(Integer lengthContent) {
        this.lengthContent = lengthContent;
    }

    public Date getPublishTime() {
        return publishTime;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public Date getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public String getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpdatedBy() {
        return updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String[] getServiceCodes() {
        return serviceCodes;
    }

    public void setServiceCodes(String[] serviceCodes) {
        this.serviceCodes = serviceCodes;
    }

    public String[] getColumns() {
        return columns;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public String[] getStdColumns() {
        return stdColumns;
    }

    public void setStdColumns(String[] stdColumns) {
        this.stdColumns = stdColumns;
    }

    public String getSupplierImg() {
        return supplierImg;
    }

    public void setSupplierImg(String supplierImg) {
        this.supplierImg = supplierImg;
    }

    public HsbcNewsDto.Extend getExtend() {
        return extend;
    }

    public void setExtend(HsbcNewsDto.Extend extend) {
        this.extend = extend;
    }

    public List<Imgs> getImgs() {
        return imgs;
    }

    public void setImgs(List<Imgs> imgs) {
        this.imgs = imgs;
    }

    public static class Extend implements Serializable{

        private static final long serialVersionUID = 8966163327492776608L;
        /** 视频url */
        private String videoUrl;

        /** 视频时长 */
        private Integer videoDuration;

        /** 音频url */
        private String audioUrl;

        public String getVideoUrl() {
            return videoUrl;
        }

        public void setVideoUrl(String videoUrl) {
            this.videoUrl = videoUrl;
        }

        public Integer getVideoDuration() {
            return videoDuration;
        }

        public void setVideoDuration(Integer videoDuration) {
            this.videoDuration = videoDuration;
        }

        public String getAudioUrl() {
            return audioUrl;
        }

        public void setAudioUrl(String audioUrl) {
            this.audioUrl = audioUrl;
        }
    }

    public static class Imgs implements Serializable{
        private static final long serialVersionUID = -1231773352834034940L;

        /** 图片地址 */
        private String url;

        /** 权重 */
        private Double weight;

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Double getWeight() {
            return weight;
        }

        public void setWeight(Double weight) {
            this.weight = weight;
        }
    }
}
