package cn.com.duiba.thirdpartyvnew.dto.wanda.response;

import lombok.Data;

import java.io.Serializable;

/**
 * 万达认证token响应DTO
 *
 * @author zhangdaqing
 * @date 2025/7/10
 */
@Data
public class WandaAuthTokenResponse implements Serializable {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 状态码；200正常
     */
    private Integer status;
    
    /**
     * 操作是否成功
     */
    private Boolean success;
    
    /**
     * 信息详情
     */
    private String message;
    
    /**
     * 响应数据
     */
    private WandaAuthTokenResponseData data;
    
    /**
     * 判断是否成功
     * 
     * @return true: 成功, false: 失败
     */
    public boolean isSuccess() {
        return status != null && status == 200 && success != null && success;
    }
} 