package cn.com.duiba.thirdpartyvnew.dto.jincheng;

import cn.com.duiba.thirdpartyvnew.dto.jincheng.top.BaseReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.top.BaseReqInterface;

import java.io.Serializable;

/**
 * 金城银行-商品预下单接口-请求入参
 *
 * @author songp
 * @date 2024/5/22 6:20 下午
 */
public class PreOrderConfirmReqDto implements BaseReqInterface, Serializable {

    /**
     * 下单场景（目前仅支持商城商品）
     * GOODS：商城商品，ACTIVITYS：活动
     */
    private String scene;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * 自有商品标识  0：否，1：是
     */
    private String selfFlag;

    /**
     * ZFBZC_vsg6:支付宝直冲
     */
    private String productTypeCode;

    /**
     * 兑吧商品id
     */
    private String appItemId;

    /**
     * 自有商品编码，自有商品时需传值,非必须
     */
    private String goodsCode;

    /**
     * 商品面额
     */
    private String goodsAmount;

    /**
     * 扣减积分
     */
    private String payScoreValue;

    /**
     * 充值账号,非必须
     */
    private String rechargeAccount;

    /**
     * 充值面额,非必须
     */
    private String rechargeAmount;

    /**
     * 基本值入参
     */
    private BaseReqDto commonParam;

    @Override
    public BaseReqDto getCommonParam() {
        return commonParam;
    }

    public void setCommonParam(BaseReqDto commonParam) {
        this.commonParam = commonParam;
    }

    public String getScene() {
        return scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getSelfFlag() {
        return selfFlag;
    }

    public void setSelfFlag(String selfFlag) {
        this.selfFlag = selfFlag;
    }

    public String getProductTypeCode() {
        return productTypeCode;
    }

    public void setProductTypeCode(String productTypeCode) {
        this.productTypeCode = productTypeCode;
    }

    public String getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(String appItemId) {
        this.appItemId = appItemId;
    }

    public String getGoodsCode() {
        return goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public String getGoodsAmount() {
        return goodsAmount;
    }

    public void setGoodsAmount(String goodsAmount) {
        this.goodsAmount = goodsAmount;
    }

    public String getPayScoreValue() {
        return payScoreValue;
    }

    public void setPayScoreValue(String payScoreValue) {
        this.payScoreValue = payScoreValue;
    }

    public String getRechargeAccount() {
        return rechargeAccount;
    }

    public void setRechargeAccount(String rechargeAccount) {
        this.rechargeAccount = rechargeAccount;
    }

    public String getRechargeAmount() {
        return rechargeAmount;
    }

    public void setRechargeAmount(String rechargeAmount) {
        this.rechargeAmount = rechargeAmount;
    }
}
