package cn.com.duiba.thirdpartyvnew.dto.lzlj.response;

import lombok.Data;

import java.io.Serializable;

/**
 * 泸州老窖扣积分接口响应数据
 * 作为LzljBaseResponse<T>中的泛型类型T
 */
@Data
public class LzljDeductCreditsResponseData implements Serializable {
    private static final long serialVersionUID = 1L;
    
    /**
     * 扣积分结果状态，回复ok或者fail（必填）
     * 限制长度：255
     * 不要使用0和1
     */
    private String status;
    
    /**
     * 出错原因（非必填）
     * 限制长度：255
     */
    private String errorMessage;
    
    /**
     * 开发者的订单号，唯一且不重复（必填）
     * 限制长度：255
     * 如果失败情况，该值可以不传
     */
    private String bizId;
    
    /**
     * 用户积分余额（必填）
     * 限制长度：20
     */
    private Long credits;
}
