package cn.com.duiba.thirdpartyvnew.dto.wlnx.response.consumer;

import java.io.Serializable;

/**
 * 积分类型数据传输对象 (DTO)
 */
public class PointTypeDTO implements Serializable {

    /**
     * 总收入积分数量
     */
    private int totalIncomeNumber;

    /**
     * 总消耗积分数量
     */
    private int totalConsumeNumber;

    /**
     * 当前有效积分数量
     */
    private int validNumber;

    /**
     * 积分类型ID
     */
    private int pointType;

    /**
     * 积分类型名称
     */
    private String pointName;

    /**
     * 即将过期的积分数量
     */
    private int nextOverdueNumber;

    /**
     * 过期时间（时间戳，单位：毫秒）
     */
    private long expireTime;

    // Getter and Setter methods

    public int getTotalIncomeNumber() {
        return totalIncomeNumber;
    }

    public void setTotalIncomeNumber(int totalIncomeNumber) {
        this.totalIncomeNumber = totalIncomeNumber;
    }

    public int getTotalConsumeNumber() {
        return totalConsumeNumber;
    }

    public void setTotalConsumeNumber(int totalConsumeNumber) {
        this.totalConsumeNumber = totalConsumeNumber;
    }

    public int getValidNumber() {
        return validNumber;
    }

    public void setValidNumber(int validNumber) {
        this.validNumber = validNumber;
    }

    public int getPointType() {
        return pointType;
    }

    public void setPointType(int pointType) {
        this.pointType = pointType;
    }

    public String getPointName() {
        return pointName;
    }

    public void setPointName(String pointName) {
        this.pointName = pointName;
    }

    public int getNextOverdueNumber() {
        return nextOverdueNumber;
    }

    public void setNextOverdueNumber(int nextOverdueNumber) {
        this.nextOverdueNumber = nextOverdueNumber;
    }

    public long getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }
}