package cn.com.duiba.thirdpartyvnew.api.wdt;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.LogisticsSyncAckReqDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.LogisticsSyncAckRespDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.LogisticsSyncQueryReqDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.LogisticsSyncQueryRespDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.TradePushReqDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.TradePushRespDto;

/**
 * 旺店通外部接口调用
 *
 * @author yangyukang
 */
@AdvancedFeignClient
public interface RemoteWdtService {

    /**
     * 创建原始订单
     *
     * @param tradePushReqDto 创建原始订单入参
     * @param supplierId 供应商ID
     * @return {@link TradePushRespDto}
     */
    TradePushRespDto tradePush(TradePushReqDto tradePushReqDto, Long supplierId);

    /**
     * 查询物流同步
     *
     * @param logisticsSyncQueryReqDto 查询物流同步入参
     * @param supplierId 供应商ID
     * @return {@link LogisticsSyncQueryRespDto}
     */
    LogisticsSyncQueryRespDto logisticsSyncQuery(LogisticsSyncQueryReqDto logisticsSyncQueryReqDto, Long supplierId);

    /**
     * 物流同步回写
     *
     * @param logisticsSyncAckReqDto 物流同步回写入参
     * @param supplierId 供应商ID
     * @return {@link LogisticsSyncAckRespDto}
     */
    LogisticsSyncAckRespDto logisticsSyncAck(LogisticsSyncAckReqDto logisticsSyncAckReqDto, Long supplierId);
}
