package cn.com.duiba.thirdpartyvnew.dto;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @program: thirdparty-all
 * @description: 扣虚拟货币服务
 * @author: Simba
 * @create: 2019-03-15 14:35
 **/
public class VirtualCurrencyMessage implements Serializable{
    private static final long serialVersionUID = -1333688201572914732L;

    public static final String MESSAGE_CHANNEL_TYPE_KEY = "callbackMessageType";
    /**调用方式**/
    public static final String HTTP_GET = "get";
    public static final String HTTP_POST = "post";

    /**
     * 用户提现记录id
     */
    private String recordId;
    /**
     * 用户账号id
     */
    private String accountId;
    /**
     * 业务ID
     */
    private String relationId;
    /**
     * 业务类型
     */
    private String relationType;
    /**
     * appId
     */
    private String appId;
    /**
     * 兑吧系统用户ID
     */
    private String consumerId;
    /**
     * http请求方式，目前支持get、set
     */
    private String httpType;
    /**
     * 请求链接
     */
    private String httpUrl;
    /**
     * 需要发送给开发者服务器，包含鉴权需要的字段，业务字段
     */
    private Map<String, String> authParams;
    /**
     * 用与消息透传，第三方服务不做处理，直接通过消息返回给消息消费者
     */
    private Map<String, String> params;

    private String msgTopic;

    private String msgTag;

    private String msgKey;

    public String getRecordId() {
        return recordId;
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public String getHttpType() {
        return httpType;
    }

    public void setHttpType(String httpType) {
        this.httpType = httpType;
    }

    public String getHttpUrl() {
        return httpUrl;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public Map<String, String> getAuthParams() {
        return authParams;
    }

    public void setAuthParams(Map<String, String> authParams) {
        this.authParams = authParams;
    }

    public String getFromAuthParmas(String key){
        if(this.authParams == null){
            return null;
        }
        return this.authParams.get(key);
    }

    public void put2AuthParams(String key, String value){
        if(this.authParams == null){
            this.authParams = new HashMap<>();
        }
        this.authParams.put(key, value);
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String getFromParmas(String key){
        if(this.params == null){
            return null;
        }
        return this.params.get(key);
    }

    public void put2Params(String key, String value){
        if(this.params == null){
            this.params = new HashMap<>();
        }
        this.params.put(key, value);
    }

    public String getMsgTopic() {
        return msgTopic;
    }

    public void setMsgTopic(String msgTopic) {
        this.msgTopic = msgTopic;
    }

    public String getMsgTag() {
        return msgTag;
    }

    public void setMsgTag(String msgTag) {
        this.msgTag = msgTag;
    }

    public String getMsgKey() {
        return msgKey;
    }

    public void setMsgKey(String msgKey) {
        this.msgKey = msgKey;
    }
}
