package cn.com.duiba.thirdpartyvnew.dto.yaduo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * trade_query.php（查询订单管理）回参DTO
 *
 * @author wgh
 */
@NoArgsConstructor
@Data
public class TradeQueryRespDto implements Serializable {

    private static final long serialVersionUID = -3521721863511546855L;
    @JSONField(name = "code")
    private Integer code;
    @JSONField(name = "message")
    private String message;
    @JSONField(name = "total_count")
    private Integer totalCount;
    @JSONField(name = "trades")
    private List<TradesDTO> trades;

    @NoArgsConstructor
    @Data
    public static class TradesDTO implements Serializable {
        private static final long serialVersionUID = -146226509060195934L;
        @JSONField(name = "trade_id")
        private String tradeId;
        @JSONField(name = "trade_no")
        private String tradeNo;
        @JSONField(name = "platform_id")
        private String platformId;
        @JSONField(name = "warehouse_type")
        private String warehouseType;
        @JSONField(name = "src_tids")
        private String srcTids;
        @JSONField(name = "pay_account")
        private String payAccount;
        @JSONField(name = "trade_status")
        private String tradeStatus;
        @JSONField(name = "consign_status")
        private String consignStatus;
        @JSONField(name = "trade_type")
        private String tradeType;
        @JSONField(name = "delivery_term")
        private String deliveryTerm;
        @JSONField(name = "freeze_reason")
        private String freezeReason;
        @JSONField(name = "refund_status")
        private String refundStatus;
        @JSONField(name = "fenxiao_type")
        private String fenxiaoType;
        @JSONField(name = "fenxiao_nick")
        private String fenxiaoNick;
        @JSONField(name = "trade_time")
        private String tradeTime;
        @JSONField(name = "pay_time")
        private String payTime;
        @JSONField(name = "buyer_nick")
        private String buyerNick;
        @JSONField(name = "receiver_name")
        private String receiverName;
        @JSONField(name = "receiver_province")
        private String receiverProvince;
        @JSONField(name = "receiver_city")
        private String receiverCity;
        @JSONField(name = "receiver_district")
        private String receiverDistrict;
        @JSONField(name = "receiver_address")
        private String receiverAddress;
        @JSONField(name = "receiver_mobile")
        private String receiverMobile;
        @JSONField(name = "receiver_telno")
        private String receiverTelno;
        @JSONField(name = "receiver_zip")
        private String receiverZip;
        @JSONField(name = "receiver_area")
        private String receiverArea;
        @JSONField(name = "receiver_ring")
        private String receiverRing;
        @JSONField(name = "receiver_dtb")
        private String receiverDtb;
        @JSONField(name = "to_deliver_time")
        private String toDeliverTime;
        @JSONField(name = "bad_reason")
        private String badReason;
        @JSONField(name = "logistics_no")
        private String logisticsNo;
        @JSONField(name = "buyer_message")
        private String buyerMessage;
        @JSONField(name = "cs_remark")
        private String csRemark;
        @JSONField(name = "remark_flag")
        private String remarkFlag;
        @JSONField(name = "print_remark")
        private String printRemark;
        @JSONField(name = "goods_type_count")
        private String goodsTypeCount;
        @JSONField(name = "goods_count")
        private String goodsCount;
        @JSONField(name = "goods_amount")
        private String goodsAmount;
        @JSONField(name = "post_amount")
        private String postAmount;
        @JSONField(name = "other_amount")
        private String otherAmount;
        @JSONField(name = "discount")
        private String discount;
        @JSONField(name = "receivable")
        private String receivable;
        @JSONField(name = "dap_amount")
        private String dapAmount;
        @JSONField(name = "cod_amount")
        private String codAmount;
        @JSONField(name = "ext_cod_fee")
        private String extCodFee;
        @JSONField(name = "goods_cost")
        private String goodsCost;
        @JSONField(name = "post_cost")
        private String postCost;
        @JSONField(name = "paid")
        private String paid;
        @JSONField(name = "weight")
        private String weight;
        @JSONField(name = "profit")
        private String profit;
        @JSONField(name = "tax")
        private String tax;
        @JSONField(name = "tax_rate")
        private String taxRate;
        @JSONField(name = "commission")
        private String commission;
        @JSONField(name = "invoice_type")
        private String invoiceType;
        @JSONField(name = "invoice_title")
        private String invoiceTitle;
        @JSONField(name = "invoice_content")
        private String invoiceContent;
        @JSONField(name = "salesman_id")
        private String salesmanId;
        @JSONField(name = "checker_id")
        private String checkerId;
        @JSONField(name = "fchecker_id")
        private String fcheckerId;
        @JSONField(name = "checkouter_id")
        private String checkouterId;
        @JSONField(name = "stockout_no")
        private String stockoutNo;
        @JSONField(name = "flag_name")
        private String flagName;
        @JSONField(name = "trade_from")
        private String tradeFrom;
        @JSONField(name = "single_spec_no")
        private String singleSpecNo;
        @JSONField(name = "raw_goods_count")
        private String rawGoodsCount;
        @JSONField(name = "raw_goods_type_count")
        private String rawGoodsTypeCount;
        @JSONField(name = "currency")
        private String currency;
        @JSONField(name = "split_package_num")
        private String splitPackageNum;
        @JSONField(name = "invoice_id")
        private String invoiceId;
        @JSONField(name = "version_id")
        private String versionId;
        @JSONField(name = "modified")
        private String modified;
        @JSONField(name = "created")
        private String created;
        @JSONField(name = "id_card_type")
        private String idCardType;
        @JSONField(name = "id_card")
        private String idCard;
        @JSONField(name = "shop_no")
        private String shopNo;
        @JSONField(name = "shop_name")
        private String shopName;
        @JSONField(name = "shop_remark")
        private String shopRemark;
        @JSONField(name = "warehouse_no")
        private String warehouseNo;
        @JSONField(name = "customer_name")
        private String customerName;
        @JSONField(name = "customer_no")
        private String customerNo;
        @JSONField(name = "logistics_id")
        private String logisticsId;
        @JSONField(name = "logistics_name")
        private String logisticsName;
        @JSONField(name = "logistics_code")
        private String logisticsCode;
        @JSONField(name = "logistics_type")
        private String logisticsType;
        @JSONField(name = "fullname")
        private String fullname;
        @JSONField(name = "checker_name")
        private String checkerName;
        @JSONField(name = "goods_list")
        private List<GoodsListDTO> goodsList;

        @NoArgsConstructor
        @Data
        public static class GoodsListDTO implements Serializable {
            private static final long serialVersionUID = -295786931880291964L;
            @JSONField(name = "rec_id")
            private String recId;
            @JSONField(name = "trade_id")
            private String tradeId;
            @JSONField(name = "spec_id")
            private String specId;
            @JSONField(name = "platform_id")
            private String platformId;
            @JSONField(name = "src_oid")
            private String srcOid;
            @JSONField(name = "suite_id")
            private String suiteId;
            @JSONField(name = "src_tid")
            private String srcTid;
            @JSONField(name = "gift_type")
            private String giftType;
            @JSONField(name = "refund_status")
            private String refundStatus;
            @JSONField(name = "guarantee_mode")
            private String guaranteeMode;
            @JSONField(name = "delivery_term")
            private String deliveryTerm;
            @JSONField(name = "bind_oid")
            private String bindOid;
            @JSONField(name = "num")
            private String num;
            @JSONField(name = "price")
            private String price;
            @JSONField(name = "actual_num")
            private String actualNum;
            @JSONField(name = "refund_num")
            private String refundNum;
            @JSONField(name = "order_price")
            private String orderPrice;
            @JSONField(name = "share_price")
            private String sharePrice;
            @JSONField(name = "adjust")
            private String adjust;
            @JSONField(name = "discount")
            private String discount;
            @JSONField(name = "share_amount")
            private String shareAmount;
            @JSONField(name = "share_post")
            private String sharePost;
            @JSONField(name = "paid")
            private String paid;
            @JSONField(name = "goods_name")
            private String goodsName;
            @JSONField(name = "goods_id")
            private String goodsId;
            @JSONField(name = "goods_no")
            private String goodsNo;
            @JSONField(name = "spec_name")
            private String specName;
            @JSONField(name = "spec_no")
            private String specNo;
            @JSONField(name = "spec_code")
            private String specCode;
            @JSONField(name = "suite_no")
            private String suiteNo;
            @JSONField(name = "flag")
            private String flag;
            @JSONField(name = "suite_name")
            private String suiteName;
            @JSONField(name = "suite_num")
            private String suiteNum;
            @JSONField(name = "suite_amount")
            private String suiteAmount;
            @JSONField(name = "suite_discount")
            private String suiteDiscount;
            @JSONField(name = "api_goods_name")
            private String apiGoodsName;
            @JSONField(name = "api_spec_name")
            private String apiSpecName;
            @JSONField(name = "weight")
            private String weight;
            @JSONField(name = "commission")
            private String commission;
            @JSONField(name = "goods_type")
            private String goodsType;
            @JSONField(name = "large_type")
            private String largeType;
            @JSONField(name = "invoice_type")
            private String invoiceType;
            @JSONField(name = "invoice_content")
            private String invoiceContent;
            @JSONField(name = "from_mask")
            private String fromMask;
            @JSONField(name = "cid")
            private String cid;
            @JSONField(name = "remark")
            private String remark;
            @JSONField(name = "modified")
            private String modified;
            @JSONField(name = "created")
            private String created;
            @JSONField(name = "platform_goods_id")
            private String platformGoodsId;
            @JSONField(name = "platform_spec_id")
            private String platformSpecId;
            @JSONField(name = "prop2")
            private String prop2;
            @JSONField(name = "tax_rate")
            private String taxRate;
        }
    }
}
