package cn.com.duiba.thirdpartyvnew.dto.lzlj.request;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class OrderDeliveryRequestData implements Serializable {
    private static final long serialVersionUID = 1L;

    private String source; // 系统来源
    private String orderType; // 是否拆单：splitOrder=拆单，N=不拆单，splitOrderFinish=拆单完成
    private Integer orderTotalQty; // 订单总的发货数量
    private String id; // 智慧营销订单 ID
    private String logisticsCompany; // 物流公司
    private String logisticsNo; // 物流单号
    private String integrationId; // 第三方订单 ID
    private List<SaleOrderItem> saleOrderItemList; // 订单详情信息

    @Data
    public static class SaleOrderItem implements Serializable {
        private static final long serialVersionUID = 1L;

        private String id; // 智慧营销订单明细 ID
        private String prodCode; // 产品编码
        private Integer qty; // 产品发货数量
    }
}

