package cn.com.duiba.thirdpartyvnew.dto.devapp;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;

/**
 * 字节广告监测链接msg
 *
 * @author wgh
 * @date 2024/01/09
 */
@Data
public class AppAdTrackingByteLinkMessage implements Serializable {

    private static final long serialVersionUID = -7118672585223510268L;

    /**
     * 主键
     */
    private Long linkId;

    /**
     * 关联app表id字段
     */
    private Long appId;

    /**
     * 行为事件类型
     */
    private String actionType;

    /**
     * 字节的点击标识
     */
    private String callback;

    /**
     * 0：点击归因
     * 1：展示归因
     * 2：有效播放归因
     * 默认 0
     */
    private Integer matchType = 0;

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static AppAdTrackingByteLinkMessage decode(byte[] msg) {
        String body = new String(msg, StandardCharsets.UTF_8);
        return JSONObject.parseObject(body, AppAdTrackingByteLinkMessage.class);
    }
}
