package cn.com.duiba.thirdpartyvnew.dto.lshm.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
@Data
@EqualsAndHashCode(callSuper = true)
public class LshmShopQueryRequest extends LshmBaseRequest implements Serializable {
    /**
     * 位置信息
     */
    private Location location;
    /**
     * 分页页码
     */
    private Integer pageNo;
    /**
     * 分页大小
     */
    private Integer pageSize;


    @Data
    public static class Location implements Serializable {
        /**
         * 经度
         */
        private String lon;
        /**
         * 纬度
         */
        private String lat;
    }
}
