package cn.com.duiba.thirdpartyvnew.api.yaduo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.LogisticsSyncAckReqDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.LogisticsSyncAckRespDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.LogisticsSyncQueryReqDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.LogisticsSyncQueryRespDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.RefundQueryReqDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.RefundQueryRespDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.SalesRefundPushReqDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.SalesRefundPushRespDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.TradePushReqDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.TradePushRespDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.TradeQueryReqDto;
import cn.com.duiba.thirdpartyvnew.dto.yaduo.TradeQueryRespDto;


/**
 * 亚朵外部接口调用
 *
 * @author wgh
 */
@AdvancedFeignClient
public interface RemoteYaduoService {

    /**
     * 创建原始订单
     *
     * @param tradePushReqDto 创建原始订单入参
     * @return {@link TradePushRespDto}
     */
    TradePushRespDto tradePush(TradePushReqDto tradePushReqDto);

    /**
     * 创建原始退款单
     *
     * @param salesRefundPushReqDto 创建原始退款单入参
     * @return {@link SalesRefundPushRespDto}
     */
    SalesRefundPushRespDto salesRefundPush(SalesRefundPushReqDto salesRefundPushReqDto);

    /**
     * 查询退换管理
     *
     * @param refundQueryReqDto 查询退换管理入参
     * @return {@link RefundQueryRespDto}
     */
    RefundQueryRespDto refundQuery(RefundQueryReqDto refundQueryReqDto);

    /**
     * 查询物流同步
     *
     * @param logisticsSyncQueryReqDto 查询物流同步入参
     * @return {@link LogisticsSyncQueryRespDto}
     */
    LogisticsSyncQueryRespDto logisticsSyncQuery(LogisticsSyncQueryReqDto logisticsSyncQueryReqDto);

    /**
     * 物流同步回写
     *
     * @param logisticsSyncAckReqDto 物流同步回写入参
     * @return {@link LogisticsSyncAckRespDto}
     */
    LogisticsSyncAckRespDto logisticsSyncAck(LogisticsSyncAckReqDto logisticsSyncAckReqDto);

    /**
     * 查询订单管理
     *
     * @param tradeQueryReqDto 查询订单管理入参
     * @return {@link TradeQueryRespDto}
     */
    TradeQueryRespDto tradeQuery(TradeQueryReqDto tradeQueryReqDto);
}
