package cn.com.duiba.thirdpartyvnew.dto.wdt;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * 旺店通接口通用返回结果包装类
 *
 * @author cgq
 * @date 2025-01-27
 */
@Data
public class WangDianTongResult<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 默认成功码
     */
    public static final String DEFAULT_SUCCESS_CODE = "0";

    /**
     * 数据包体
     */
    private T data;

    /**
     * 返回code
     */
    private String status;

    /**
     * 错误信息
     */
    private String message;

    /**
     * 总条数
     */
    private Long total;

    public Boolean isSuccess() {
        if (StringUtils.isNotBlank(status) && DEFAULT_SUCCESS_CODE.equals(status)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }
}
