package cn.com.duiba.thirdpartyvnew.dto.jincheng;

import cn.com.duiba.thirdpartyvnew.dto.jincheng.top.BaseReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.top.BaseReqInterface;

import java.io.Serializable;

/**
 * 金城银行-加积分接口-请求入参
 *
 * @author songp
 * @date 2024/5/22 7:37 下午
 */
public class AddScoreReqDto implements BaseReqInterface, Serializable {

    /**
     * uid
     */
    private String uid;

    /**
     * appkey
     */
    private String appKey;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * game(游戏), sign(签到),task(pk赛), reSign(补签)，
     * postsale(售后退积分)，cancelShip(取消发货-购物车场景下存在)，
     * hdtool(加积分活动)所有类型不区分大小写，本次仅支持售后
     */
    private String type;

    /**
     * 本次增加积分
     */
    private String credits;

    /**
     * 描述
     */
    private String description;

    /**
     * timestamp
     */
    private String timestamp;

    /**
     * order status(fail-订单失败，aftersale-售后)
     */
    private String orderStatus;

    @Override
    public BaseReqDto getCommonParam() {
        return null;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCredits() {
        return credits;
    }

    public void setCredits(String credits) {
        this.credits = credits;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }
}
