package cn.com.duiba.thirdpartyvnew.api.jingneng;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.jingneng.CancelConsumePointReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jingneng.CancelConsumePointRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jingneng.ConsumeCreditRequestReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jingneng.ConsumeCreditRequestRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jingneng.ConsumePointReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jingneng.ConsumePointRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jingneng.GetTokenReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jingneng.GetTokenRespDto;
import cn.com.duiba.thirdpartyvnew.dto.jingneng.SearchMemberByIdReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jingneng.SearchMemberByIdRespDto;

/**
 * 京能外部接口调用
 *
 * @author wgh
 */
@AdvancedFeignClient
public interface RemoteJingnengService {

    /**
     * 安全认证
     *
     * @param getTokenReqDto 安全认证入参
     * @return {@link GetTokenRespDto}
     */
    GetTokenRespDto getToken(GetTokenReqDto getTokenReqDto);

    /**
     * 根据会员ID查询单个会员基础信息
     *
     * @param searchMemberByIdReqDto 根据会员ID查询单个会员基础信息入参
     * @return {@link SearchMemberByIdRespDto}
     */
    SearchMemberByIdRespDto searchMemberById(SearchMemberByIdReqDto searchMemberByIdReqDto);

    /**
     * 会员积分添加
     *
     * @param consumeCreditRequestReqDto 会员积分添加入参
     * @return {@link ConsumeCreditRequestRespDto}
     */
    ConsumeCreditRequestRespDto consumeCreditRequest(ConsumeCreditRequestReqDto consumeCreditRequestReqDto);

    /**
     * 积分消费
     *
     * @param consumePointReqDto 积分消费入参
     * @return {@link ConsumePointRespDto}
     */
    ConsumePointRespDto consumePoint(ConsumePointReqDto consumePointReqDto);

    /**
     * 取消积分消费
     *
     * @param cancelConsumePointReqDto 取消积分消费入参
     * @return {@link CancelConsumePointRespDto}
     */
    CancelConsumePointRespDto cancelConsumePoint(CancelConsumePointReqDto cancelConsumePointReqDto);

}
