package cn.com.duiba.thirdpartyvnew.dto.hsbc;

import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import java.util.Set;

/**
 * 汇丰银行(hsbc)配置dto
 *
 * @author zouwx
 * @date 2022/06/02
 */
public class HsbcConfigDTO implements Serializable {


    private static final long serialVersionUID = -6165234360848045048L;

    private final static String ALGORITHM_RSA = "RSA";

    private Set<Long> appIds;

    /**
     * 兑吧私钥配置
     */
    private String appId2RsaDuibaPrivateKeyConf;

    /**
     * {汇丰应用id: rsaPrivateKey配置}
     */
    private Map<String, String> appId2RsaDuibaPrivateKeyConfMap;

    private Map<Long, PrivateKey> appId2RsaDuibaPrivateKeyMap;


    /**
     * 汇丰业务rsa公钥 apollo配置集合
     */
    private String appId2HsbcKeyConf;
    /**
     * 汇丰jwt rsa私钥 apollo配置集合
     */
    private String appId2JwtKeyConf;
    /**
     * 免登用户信息查询接口配置集合
     */
    private String appId2UserInfoUrlConf;

    /**
     * 积分任务列表查询接口配置集合
     */
    private String appId2PointTaskListUrlConf;

    /**
     * 积分任务状态接口配置集合
     */
    private String appId2PointTaskStatusUrlConf;

    /**
     * {汇丰应用id: rsaPublicKey配置}
     */
    private Map<String, String> appId2HsbcKeyConfMap;

    /**
     * {汇丰应用id: jwtPrivateKey配置}
     */
    private Map<String, String> appId2JwtKeyConfMap;

    /**
     * {汇丰应用id: url配置}
     */
    private Map<String, String> appId2UserInfoUrlMap;


    /**
     * {汇丰应用id: 积分任务列表url配置}
     */
    private Map<String, String> appId2PointTaskListUrlMap;


    /**
     * {汇丰应用id: 积分任务状态查询url配置}
     */
    private Map<String, String> appId2PointTaskStatusUrlMap;

    /**
     * {汇丰应用id: key配置}
     */
    private Map<Long, PublicKey> appId2HsbcPublicKeyMap;

    /**
     * 是否汇丰汇选的app
     *
     * @param appId 应用id
     * @return true: 汇丰app
     */
    public boolean isHsbcApp(Long appId) {
        return appIds.contains(appId);
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getAppId2RsaDuibaPrivateKeyConf() {
        return appId2RsaDuibaPrivateKeyConf;
    }

    public void setAppId2RsaDuibaPrivateKeyConf(String appId2RsaDuibaPrivateKeyConf) {
        this.appId2RsaDuibaPrivateKeyConf = appId2RsaDuibaPrivateKeyConf;
    }

    public Map<String, String> getAppId2RsaDuibaPrivateKeyConfMap() {
        return appId2RsaDuibaPrivateKeyConfMap;
    }

    public void setAppId2RsaDuibaPrivateKeyConfMap(Map<String, String> appId2RsaDuibaPrivateKeyConfMap) {
        this.appId2RsaDuibaPrivateKeyConfMap = appId2RsaDuibaPrivateKeyConfMap;
    }

    public Map<Long, PrivateKey> getAppId2RsaDuibaPrivateKeyMap() {
        return appId2RsaDuibaPrivateKeyMap;
    }

    public void setAppId2RsaDuibaPrivateKeyMap(Map<Long, PrivateKey> appId2RsaDuibaPrivateKeyMap) {
        this.appId2RsaDuibaPrivateKeyMap = appId2RsaDuibaPrivateKeyMap;
    }

    public String getAppId2HsbcKeyConf() {
        return appId2HsbcKeyConf;
    }

    public void setAppId2HsbcKeyConf(String appId2HsbcKeyConf) {
        this.appId2HsbcKeyConf = appId2HsbcKeyConf;
    }

    public String getAppId2JwtKeyConf() {
        return appId2JwtKeyConf;
    }

    public void setAppId2JwtKeyConf(String appId2JwtKeyConf) {
        this.appId2JwtKeyConf = appId2JwtKeyConf;
    }

    public String getAppId2UserInfoUrlConf() {
        return appId2UserInfoUrlConf;
    }

    public void setAppId2UserInfoUrlConf(String appId2UserInfoUrlConf) {
        this.appId2UserInfoUrlConf = appId2UserInfoUrlConf;
    }

    public String getAppId2PointTaskListUrlConf() {
        return appId2PointTaskListUrlConf;
    }

    public void setAppId2PointTaskListUrlConf(String appId2PointTaskListUrlConf) {
        this.appId2PointTaskListUrlConf = appId2PointTaskListUrlConf;
    }

    public String getAppId2PointTaskStatusUrlConf() {
        return appId2PointTaskStatusUrlConf;
    }

    public void setAppId2PointTaskStatusUrlConf(String appId2PointTaskStatusUrlConf) {
        this.appId2PointTaskStatusUrlConf = appId2PointTaskStatusUrlConf;
    }

    public Map<String, String> getAppId2HsbcKeyConfMap() {
        return appId2HsbcKeyConfMap;
    }

    public void setAppId2HsbcKeyConfMap(Map<String, String> appId2HsbcKeyConfMap) {
        this.appId2HsbcKeyConfMap = appId2HsbcKeyConfMap;
    }

    public Map<String, String> getAppId2JwtKeyConfMap() {
        return appId2JwtKeyConfMap;
    }

    public void setAppId2JwtKeyConfMap(Map<String, String> appId2JwtKeyConfMap) {
        this.appId2JwtKeyConfMap = appId2JwtKeyConfMap;
    }

    public Map<String, String> getAppId2UserInfoUrlMap() {
        return appId2UserInfoUrlMap;
    }

    public void setAppId2UserInfoUrlMap(Map<String, String> appId2UserInfoUrlMap) {
        this.appId2UserInfoUrlMap = appId2UserInfoUrlMap;
    }

    public Map<String, String> getAppId2PointTaskListUrlMap() {
        return appId2PointTaskListUrlMap;
    }

    public void setAppId2PointTaskListUrlMap(Map<String, String> appId2PointTaskListUrlMap) {
        this.appId2PointTaskListUrlMap = appId2PointTaskListUrlMap;
    }

    public Map<String, String> getAppId2PointTaskStatusUrlMap() {
        return appId2PointTaskStatusUrlMap;
    }

    public void setAppId2PointTaskStatusUrlMap(Map<String, String> appId2PointTaskStatusUrlMap) {
        this.appId2PointTaskStatusUrlMap = appId2PointTaskStatusUrlMap;
    }

    public Map<Long, PublicKey> getAppId2HsbcPublicKeyMap() {
        return appId2HsbcPublicKeyMap;
    }

    public void setAppId2HsbcPublicKeyMap(Map<Long, PublicKey> appId2HsbcPublicKeyMap) {
        this.appId2HsbcPublicKeyMap = appId2HsbcPublicKeyMap;
    }
}
