package cn.com.duiba.thirdpartyvnew.dto.mianyibaodian;

import lombok.Data;

import java.io.Serializable;
@Data
public class MybdActivityRequest implements Serializable {
    /**
     * 应用程序的唯一标识符。
     */
    private String appKey;

    /**
     * 签名，用于验证请求的合法性。
     */
    private String sign;

    /**
     * 请求的时间戳，表示抽奖活动的参与时间。
     */
    private long timestamp;

    /**
     * 中奖的奖品名称，如果没有中奖则为"谢谢参与"。
     */
    private String prizeName;

    /**
     * 抽奖活动的ID。
     */
    private String activityId;

    /**
     * 抽奖活动的名称。
     */
    private String activityName;

    /**
     * 免登录状态下携带的transfer参数，具体含义由抽奖平台定义。
     */
    private String transfer;

    /**
     * 参与抽奖消耗的积分数量，免费参与则为零。
     */
    private int consumerCredit;

    /**
     * 中奖后需要手动领取的订单号，如果无需手动领取则为空。
     */
    private String orderNum;

    /**
     * 用户身份标识
     */
    private String uid;
}
