package cn.com.duiba.thirdpartyvnew.dto.yaduo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * trade_push.php（创建原始订单）入参DTO
 *
 * @author wgh
 */
@Data
public class TradePushReqDto implements Serializable {

    private static final long serialVersionUID = -1047347231427766232L;

    /**
     * 店铺编号
     */
    @JSONField(name = "shop_no")
    private String shopNo;

    /**
     * 订单列表节点
     */
    @JSONField(name = "trade_list")
    private List<TradeListItem> tradeList;

    /**
     * 订单列表节点项
     *
     * @author wgh
     */
    @Data
    public static class TradeListItem implements Serializable {

        private static final long serialVersionUID = -7887973998558293990L;

        /**
         * 原始单号
         */
        @JSONField(name = "tid")
        private String tid;

        /**
         * 平台状态（10:未确认 20:待尾款 30:已付款待发货 40:部分发货 50:已发货 70:已完成 80:已退款 90:已关闭）
         */
        @JSONField(name = "trade_status")
        private Integer tradeStatus;

        /**
         * 发货条件（1:款到发货,2:货到付款(包含部分货到付款),3:分期付款,4:挂账）
         */
        @JSONField(name = "delivery_term")
        private Integer deliveryTerm;

        /**
         * 支付时间（yyyy-MM-dd HH:mm:ss）
         */
        @JSONField(name = "pay_time", format = "yyyy-MM-dd HH:mm:ss")
        private Date payTime;

        /**
         * 客户网名
         */
        @JSONField(name = "buyer_nick")
        private String buyerNick;

        /**
         * 收件人
         */
        @JSONField(name = "receiver_name")
        private String receiverName;

        /**
         * 省份
         */
        @JSONField(name = "receiver_province")
        private String receiverProvince;

        /**
         * 城市
         */
        @JSONField(name = "receiver_city")
        private String receiverCity;

        /**
         * 区县
         */
        @JSONField(name = "receiver_district")
        private String receiverDistrict;

        /**
         * 地址详情
         */
        @JSONField(name = "receiver_address")
        private String receiverAddress;

        /**
         * 手机
         */
        @JSONField(name = "receiver_mobile")
        private String receiverMobile;

        /**
         * 邮费
         */
        @JSONField(name = "post_amount")
        private String postAmount;

        /**
         * 货到付款金额
         */
        @JSONField(name = "cod_amount")
        private String codAmount;

        /**
         * 货到付款买家费用
         */
        @JSONField(name = "ext_cod_fee")
        private String extCodFee;

        /**
         * 其它收费
         */
        @JSONField(name = "other_amount")
        private String otherAmount;

        /**
         * 已付
         */
        @JSONField(name = "paid")
        private String paid;

        /**
         * 订单货品明细节点
         */
        @JSONField(name = "order_list")
        private List<OrderListItem> orderList;

        /**
         * 订单节点项
         *
         * @author wgh
         */
        @Data
        public static class OrderListItem implements Serializable {

            private static final long serialVersionUID = 3545011049561698686L;

            /**
             * 子订单编号
             */
            @JSONField(name = "oid")
            private String oid;

            /**
             * 数量
             */
            @JSONField(name = "num")
            private Integer num;

            /**
             * 单价
             */
            @JSONField(name = "price")
            private String price;

            /**
             * 状态（10:未确认 20:待尾款 30:已付款待发货 40:部分发货 50:已发货 70:已完成 80:已退款 90:已关闭）
             */
            @JSONField(name = "status")
            private Integer status;

            /**
             * 退款状态（0:无退款,1:取消退款,2:已申请退款,3:等待退货,4:等待收货,5:退款成功）
             */
            @JSONField(name = "refund_status")
            private Integer refundStatus;

            /**
             * 平台货品ID
             */
            @JSONField(name = "goods_id")
            private String goodsId;

            /**
             * 规格编码
             */
            @JSONField(name = "spec_no")
            private String specNo;

            /**
             * 货品名称
             */
            @JSONField(name = "goods_name")
            private String goodsName;

            /**
             * 调整
             */
            @JSONField(name = "adjust_amount")
            private String adjustAmount;

            /**
             * 优惠
             */
            @JSONField(name = "discount")
            private String discount;

            /**
             * 分摊优惠
             */
            @JSONField(name = "share_discount")
            private String shareDiscount;
        }
    }
}
