package cn.com.duiba.thirdpartyvnew.dto;

import cn.com.duiba.wolf.utils.BeanUtils;

import java.io.Serializable;

/**
 * 虚拟卡回调消息
 * Created by xiaoxuda on 2017/8/30.
 */
public class VirtualCardCallbackMessage extends VirtualCardMessage implements Serializable {
    private static final long serialVersionUID = -7640007467294997206L;

    public static final String CALLBACK_TYPE_FAILED = "failed";
    public static final String CALLBACK_TYPE_CANCELLED = "cancelled";
    public static final String CALLBACK_TYPE_COMPLETED = "completed";

    /**
     * 处理结果
     */
    private String callbackType;
    /**
     * type=completed时为开发者响应消息，其他情况为原因说明
     */
    private String message;

    /**
     * 默认构造函数
     */
    public VirtualCardCallbackMessage(){}

    /**
     * 拷贝父类属性
     * @param message
     */
    public VirtualCardCallbackMessage(VirtualCardMessage message){
        if(message != null){
            BeanUtils.copy(message, this);
        }
    }

    public String getCallbackType() {
        return callbackType;
    }

    public void setCallbackType(String callbackType) {
        this.callbackType = callbackType;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
