package cn.com.duiba.thirdpartyvnew.dto.devapp;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;

/**
 * 广告监测链接msg
 *
 * @author wgh
 * @date 2024/01/09
 */
@Data
public class AppAdTrackingLinkMessage implements Serializable {

    private static final long serialVersionUID = -7118672585223510268L;

    /**
     * 主键
     */
    private Long linkId;

    /**
     * 关联app表id字段
     */
    private Long appId;

    /**
     * 行为类型
     */
    private String actionType;

    /**
     * 回调请求
     */
    private String callback;

    /**
     * 点击id
     */
    private String clickId;

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static AppAdTrackingLinkMessage decode(byte[] msg) {
        String body = new String(msg, StandardCharsets.UTF_8);
        return JSONObject.parseObject(body, AppAdTrackingLinkMessage.class);
    }
}
