package cn.com.duiba.thirdpartyvnew.mq.msg;

import cn.com.duiba.thirdpartyvnew.enums.NotifyTypeEnum;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Date;

/**
 * 通知开发者消息
 */
public class NotifyDeveloperMsg implements Serializable {
    private static final long serialVersionUID = -7553262208901454018L;

    private NotifyTypeEnum relationType;
    private Long relationId;
    private Long appId;
    private Long consumerId;
    private Boolean result;
    private Date nextTime;
    private Integer times;
    private String error4developer;
    private String developerBizId;
    private String duibaOrderNum;
    private String partnerUserId;
    private String transfer;
    private Integer notifyType;

    public NotifyTypeEnum getRelationType() {
        return relationType;
    }

    public void setRelationType(NotifyTypeEnum relationType) {
        this.relationType = relationType;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Boolean getResult() {
        return result;
    }

    public void setResult(Boolean result) {
        this.result = result;
    }

    public Date getNextTime() {
        return nextTime;
    }

    public void setNextTime(Date nextTime) {
        this.nextTime = nextTime;
    }

    public Integer getTimes() {
        return times;
    }

    public void setTimes(Integer times) {
        this.times = times;
    }

    public String getError4developer() {
        return error4developer;
    }

    public void setError4developer(String error4developer) {
        this.error4developer = error4developer;
    }

    public String getDeveloperBizId() {
        return developerBizId;
    }

    public void setDeveloperBizId(String developerBizId) {
        this.developerBizId = developerBizId;
    }

    public String getDuibaOrderNum() {
        return duibaOrderNum;
    }

    public void setDuibaOrderNum(String duibaOrderNum) {
        this.duibaOrderNum = duibaOrderNum;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public String getTransfer() {
        return transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    public Integer getNotifyType() {
        return notifyType;
    }

    public void setNotifyType(Integer notifyType) {
        this.notifyType = notifyType;
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static NotifyDeveloperMsg decode(byte[] msg) {
        String body = new String(msg, Charset.forName("utf-8"));
        return JSONObject.parseObject(body, NotifyDeveloperMsg.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param notifyDeveloperMsg
     * @return
     */
    public static byte[] encode(NotifyDeveloperMsg notifyDeveloperMsg) {
        String string = JSONObject.toJSONString(notifyDeveloperMsg);
        return string.getBytes(Charset.forName("utf-8"));
    }
}
