package cn.com.duiba.thirdparty.alarm;

import cn.com.duiba.thirdparty.dto.MailEntity;
import cn.com.duiba.thirdparty.dto.MailSenderConstant;
import com.alibaba.fastjson.JSON;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import java.util.Properties;

/**
 * 邮件消息
 */
public class Mail {

    private static JavaMailSenderImpl sender;

    static {
        sender = new JavaMailSenderImpl();
        sender.setHost("smtp.exmail.qq.com");
        sender.setPort(465);
        sender.setProtocol("smtp");
        sender.setDefaultEncoding("utf-8");
        sender.setUsername("system@duiba.com.cn");
        sender.setPassword("gGisd7c1UP0pBMt2");
        sender.setDefaultEncoding("UTF-8");
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.ssl.enable",true);
        props.put("mail.smtp.socketFactory.port", 465);
        props.put("mail.smtp.timeout", 3000);
        props.put("mail.smtp.socketFactory.class", javax.net.ssl.SSLSocketFactory.class);
        props.put("mail.smtp.socketFactory.fallback", false);
        props.put("mail.smtp.quitwait",false);
        Session session = Session.getInstance(props);
        sender.setSession(session);
    }

    private Mail(){
        //do nothing for fixing sonar issue
    }

    /**
     * 发送邮件
     * @param toMail
     * @param subject
     * @param text
     * @param isHtml
     * @return
     * @throws Exception
     */
    public static boolean send(String[] toMail, String subject, String text, boolean isHtml) throws MessagingException {
        MimeMessage mail = sender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mail);
        helper.setTo(toMail);
        helper.setSubject(subject);
        helper.setFrom("system@duiba.com.cn");
        helper.setText(text, isHtml);
        sender.send(mail);
        return true;
    }


    public static boolean send(MailEntity entity) throws MessagingException {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();

        sender.setHost(MailSenderConstant.HOST);
        sender.setPort(MailSenderConstant.PORT);
        sender.setProtocol(MailSenderConstant.PROTOCOL);
        sender.setDefaultEncoding(MailSenderConstant.ENCODING);
        sender.setUsername(entity.getFrom());
        sender.setPassword(entity.getPassword());
        sender.setDefaultEncoding(MailSenderConstant.ENCODING);

        Session session = Session.getInstance(MailSenderConstant.props);
        sender.setSession(session);

        MimeMessage mail = sender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mail);
        helper.setTo(entity.getTo());
        helper.setSubject(entity.getSubject());
        helper.setFrom(entity.getFrom());
        helper.setText(entity.getContentText(), entity.getHtml());
        sender.send(mail);
        return true;
    }

    public static void main(String[] args) {
        try {
            System.out.println(JSON.toJSONString(sender));
            String[] toMail={"xx@duiba.com.cn"};
            send(toMail,"aa","cc",false);
            System.out.println(JSON.toJSONString(sender));
            MailEntity entity = new MailEntity();
            entity.setContentText("sss");
            entity.setFrom("vv@dd.bb");
            entity.setPassword("zzzz");
            entity.setSubject("2222");
            entity.setTo(toMail);
            send(entity);
            System.out.println(JSON.toJSONString(sender));
        } catch (MessagingException e) {
            e.printStackTrace();
        }
    }
}
