package cn.com.duiba.thirdparty.api.zhiji;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiBlindBoxRequest;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiGoodsRequest;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiOrderInfoDto;
import cn.com.duiba.thirdparty.dto.zhiji.ZhiJiUserReceivedAddressDto;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiSignProtocolRequest;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiDistrictResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiOrderResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiProtocolResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.List;
import java.util.Map;

/**
 * @author: pengyi
 * @description: 智己汽车-对外接口
 * @date: 2021/9/1 下午1:49
 */
@AdvancedFeignClient
public interface RemoteZhiJiService {

    /**
     * 新增收获地址
     * @param dto
     * @return
     */
    String saveReceiveAddress(ZhiJiUserReceivedAddressDto dto);

    /**
     * 删除收获地址
     * @param dto
     * @return
     */
    Boolean removeReceiveAddress(ZhiJiUserReceivedAddressDto dto);

    /**
     * 修改收获地址
     * @param dto
     * @return
     */
    Boolean updateReceiveAddress(ZhiJiUserReceivedAddressDto dto);

    /**
     * 查询收获地址
     * @param uid
     * @return
     */
    List<ZhiJiUserReceivedAddressDto> selectReceiveAddress(String uid);

    /**
     * 同步订单信息
     * 重试机制：第一次请求失败后重试一次，依旧失败，打印日志
     * @param orderInfoDto
     * @return
     */
    ZhiJiOrderResponse syncOrderInfo(ZhiJiOrderInfoDto orderInfoDto);

    /**
     * 同步订单状态
     * @param orderNum
     * @param status
     * @return
     */
    ZhiJiOrderResponse syncOrderStatus(String orderNum, String status);

    /**
     * 根据token 查询用户积分信息
     * @param token
     * @return
     */
    JSONObject getUserCredits(String token);

    /**
     * 根据token 查询用户信息
     * @param token
     * @return
     */
    JSONObject queryUserInfo(String token);

    /**
     * 同步商品信息
     * @param zhiJiGoodsRequestList
     * @return
     */
    boolean syncGoods(List<ZhiJiGoodsRequest> zhiJiGoodsRequestList);

    /**
     * 查询省市区
     * @param keywords
     * @param subDistrict
     * @param filter
     * @return
     */
    JSONArray queryDistrictList(String keywords, Integer subDistrict, String filter);

    /**
     * 盲盒发奖校验
     * @param uid
     * @param blindBoxId
     * @param goodsId
     * @return
     */
    @Deprecated
    Boolean blindBoxVerify(String uid,String blindBoxId,String goodsId);

    /**
     * 盲盒发奖成功通知
     * @param request
     */
    @Deprecated
    void notifyBlindBoxWriteOff(ZhiJiBlindBoxRequest request);

    /**
     * 批量查询订单收货地址
     * @param orderIds
     * @return key是兑吧订单号，value是收货信息
     */
    JSONObject queryOrderAddress(List<String> orderIds);

    /**
     * 退货物流信息推送
     * @param params
     * @return
     */
    JSONObject insertWebOrderExpress(Map<String,Object> params);

    /**
     * 推送通知接口
     * @param
     * @return
     */
    void pushMsg(String nickname, String itemName, String uid, String status);

    /**
     * 根据id获取隐私协议
     * @param protocolId
     * @return
     */
    @Deprecated
    ZhiJiProtocolResponse getProtocolById(String protocolId);

    /**
     * 获取协议版本
     * @param accessToken
     * @return
     */
    @Deprecated
    Double getProtocolVersion(String accessToken);

    /**
     * 签署协议
     * @param request
     * @return
     */
    @Deprecated
    Boolean signProtocol(ZhiJiSignProtocolRequest request);
}
