package cn.com.duiba.thirdparty.dto;

import cn.com.duiba.thirdparty.enums.CreditsLogChangeTypeEnum;
import cn.com.duiba.thirdparty.enums.CreditsLogStatusEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by fangdong on 2018/10/17
 */
public class ConsumerCreditsLogSaveDto implements Serializable {
    private static final long serialVersionUID = 5769602366195681455L;

    /**
     * consumerId
     */
    private Long consumerId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 开发者的订单号(唯一且不重复，如果失败情况，该值可以不传)
     */
    private String developerBizId;

    /**
     * 订单业务类型，兑换类型：alipay(支付宝), qb(Q币), coupon(优惠券), object(实物), phonebill(话费), phoneflow(流量),
     * virtual(虚拟商品),game(游戏), hdtool(活动抽奖),sign(签到)，reSign(补签)所有类型不区分大小写
     *
     * {@link cn.com.duiba.api.enums.subcredits.SubCreditsOuterType}
     * {@link cn.com.duiba.api.enums.addcredits.AddCreditsOuterType}
     */
    private String bizType;

    /**
     * 兑吧业务id，不要求唯一
     */
    private String bizId;

    /**
     * 关联业务类型
     */
    private String relationType;

    /**
     * 关联业务id
     */
    private String relationId;

    /**
     * 变动类型
     */
    private CreditsLogChangeTypeEnum changeType;

    /**
     * 积分数量
     */
    private Long credits;

    /**
     * 状态
     */
    private CreditsLogStatusEnum logStatus;

    /**
     * 下单时间
     */
    private Date orderTime;

    /**
     * 描述
     */
    private String description;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getDeveloperBizId() {
        return developerBizId;
    }

    public void setDeveloperBizId(String developerBizId) {
        this.developerBizId = developerBizId;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public CreditsLogChangeTypeEnum getChangeType() {
        return changeType;
    }

    public void setChangeType(CreditsLogChangeTypeEnum changeType) {
        this.changeType = changeType;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public CreditsLogStatusEnum getLogStatus() {
        return logStatus;
    }

    public void setLogStatus(CreditsLogStatusEnum logStatus) {
        this.logStatus = logStatus;
    }

    public Date getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    @Override
    public String toString() {
        return "ConsumerCreditsLogSaveDto{" +
                "consumerId=" + consumerId +
                ", appId=" + appId +
                ", orderNum='" + orderNum + '\'' +
                ", developerBizId='" + developerBizId + '\'' +
                ", bizType='" + bizType + '\'' +
                ", bizId='" + bizId + '\'' +
                ", relationType='" + relationType + '\'' +
                ", relationId='" + relationId + '\'' +
                ", changeType=" + changeType +
                ", credits=" + credits +
                ", logStatus=" + logStatus +
                ", orderTime=" + orderTime +
                ", description='" + description + '\'' +
                '}';
    }
}
