package cn.com.duiba.thirdparty.dto.hsbc;

import java.io.Serializable;
import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2022/7/6 上午10:41
 */
public class HsbcNewsPageParam implements Serializable {
    private static final long serialVersionUID = -1099448025520248399L;

    /** 栏目 */
    private List<String> columns;

    /** 服务 */
    private List<String> serviceCodes;

    /** 起始发布日期 */
    private String publishStart;

    /** 截止发布日期 */
    private String publishEnd;

    /** 展示标签 */
    private List<String> showTags;

    /** 个股标签 */
    private List<String> stockTags;

    /** 自动标签 */
    private List<String> autoTags;

    /** 标题 */
    private String title;

    /** 正文 */
    private String content;

    /** 0-精简模式（去除正文）；1-组合模式（包含正文） */
    private Integer mode;

    /** 资讯状态，默认NORMAL */
    private String status = "NORMAL";

    /** 资讯类型 */
    private String itemType;

    /** CACHE-从缓存查；ES-从ES查 */
    private String storage;

    /** 分页参数 */
    private Paging paging;

    public List<String> getColumns() {
        return columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public List<String> getServiceCodes() {
        return serviceCodes;
    }

    public void setServiceCodes(List<String> serviceCodes) {
        this.serviceCodes = serviceCodes;
    }

    public String getPublishStart() {
        return publishStart;
    }

    public void setPublishStart(String publishStart) {
        this.publishStart = publishStart;
    }

    public String getPublishEnd() {
        return publishEnd;
    }

    public void setPublishEnd(String publishEnd) {
        this.publishEnd = publishEnd;
    }

    public List<String> getShowTags() {
        return showTags;
    }

    public void setShowTags(List<String> showTags) {
        this.showTags = showTags;
    }

    public List<String> getStockTags() {
        return stockTags;
    }

    public void setStockTags(List<String> stockTags) {
        this.stockTags = stockTags;
    }

    public List<String> getAutoTags() {
        return autoTags;
    }

    public void setAutoTags(List<String> autoTags) {
        this.autoTags = autoTags;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getMode() {
        return mode;
    }

    public void setMode(Integer mode) {
        this.mode = mode;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getStorage() {
        return storage;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public Paging getPaging() {
        return paging;
    }

    public void setPaging(Paging paging) {
        this.paging = paging;
    }

    public static class Paging implements Serializable {

        private static final long serialVersionUID = 1569830327832464731L;

        /** 分页大小 */
        private Integer size = 10;

        /** 起始页 */
        private Integer page = 1;

        public Paging() {
        }

        public Paging(Integer page, Integer size) {
            this.size = size;
            this.page = page;
        }

        public Integer getSize() {
            return size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getPage() {
            return page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }
    }
}
