package cn.com.duiba.thirdparty.enums.hsbc;

import java.util.Objects;

/**
 * @Author: fss
 * @Date: 2022/10/11 14
 * @Description:
 */
public enum UserRiskLevelEnum {

    NORMAL("1", "正常用户"),
    SLIDE("2", "需滑块验证"),
    ERROR("3", "非法用户"),
    ;

    private String riskLevel;
    private String desc;

    UserRiskLevelEnum(String riskLevel, String desc) {
        this.riskLevel = riskLevel;
        this.desc = desc;
    }

    public static UserRiskLevelEnum valueOfRiskLevel(String riskLevel) {
        for (UserRiskLevelEnum obj : UserRiskLevelEnum.values()) {
            if (Objects.equals(obj.riskLevel, riskLevel)) {
                return obj;
            }
        }
        return null;
    }

    public String getRiskLevel() {
        return riskLevel;
    }

    public String getDesc() {
        return desc;
    }

}
