package cn.com.duiba.thirdparty.dto.qiyu;

import java.io.Serializable;

public class StaffMessageDto implements Serializable {

    private static final long serialVersionUID = 2057565315769425181L;
    /**
     * 错误码。200表示分配到客服，14005：没有客服在线，14006：需要排队，14010：没有客服在线，且留言功能已关闭。
     */
    private String code;

    /**
     * 客服id
     */
    private String staffId;
    /**
     * 如果分配到客服，此字段是客服的欢迎语，如果没有分配到客服，则是错误提示信息。
     */
    private String message;
    /**
     * 仅返回需要排队时该参数有效，表明排队队列中排在你前面你的人数。如果为0，则表示你排在队列最前面。
     */
    private String count;

    /**
     * 会话 ID，后续对会话评价时有用。仅返回分配到客服时该参数有效。
     */
    private String sessionId;

    /**
     * 客服名字。
     */
    private String staffName;
    /**
     * 请求分配的客服类型，如果传0，表示机器人，传1表示人工。默认为机器人。
     * 汇丰需求只会出现1，不会为0
     */
    private String staffType;
    /**
     * 客服头像的 url
     */
    private String staffIcon;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getStaffId() {
        return staffId;
    }

    public void setStaffId(String staffId) {
        this.staffId = staffId;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCount() {
        return count;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getSessionId() {
        return sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getStaffName() {
        return staffName;
    }

    public void setStaffName(String staffName) {
        this.staffName = staffName;
    }

    public String getStaffType() {
        return staffType;
    }

    public void setStaffType(String staffType) {
        this.staffType = staffType;
    }

    public String getStaffIcon() {
        return staffIcon;
    }

    public void setStaffIcon(String staffIcon) {
        this.staffIcon = staffIcon;
    }
}
