package cn.com.duiba.thirdparty.dto.hsbc;

import java.util.Date;

/**
 * 实体类用于接收和处理汇丰积分账户的订单信息
 */
public class HsbcCxaOrderSyncParam {

    /**
     * 汇丰积分账户的用户id
     */
    private String userId;

    /**
     * 兑吧商品id
     */
    private String appItemId;

    /**
     * 商品图文详情
     */
    private String description;

    /**
     * 普兑为空；placeCode为4时传活动名称
     */
    private String activityName;

    /**
     * 普兑为空；placeCode为4时传活动id
     */
    private String activityId;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * 汇丰订单号
     */
    private String hsbcOrderId;

    /**
     * 渠道标识【1、会员；2、emp活动；3、积分；4、app活动】
     */
    private String placeCode;

    /**
     * 商品图片地址
     */
    private String smallImage;

    /**
     * 下单时间
     */
    private Date createTime;

    /**
     * 用户支付金额
     */
    private String consumerPayPrice;

    /**
     * 订单详情页地址，需通过免登url访问
     */
    private String orderUrl;

    /**
     * 商品类型
     */
    private String type;

    /**
     * 物流单号（实物必填）
     */
    private String deliveryCompanyNo;

    /**
     * 物流公司名称（实物必填）
     */
    private String deliveryCompanyName;

    /**
     * 优惠券码（优惠券/卡密必填）
     */
    private String code;

    /**
     * 优惠券有效期开始时间（优惠券/卡密必填），单位：时间戳，毫秒值
     */
    private Long cardBeginTime;

    /**
     * 密码（卡密必填）
     */
    private String password;

    /**
     * 优惠券有效期结束时间（优惠券/卡密必填），单位：时间戳，毫秒值
     */
    private Long cardEndTime;

    /**
     * 优惠券链接，链接券必传
     */
    private String link;

    /**
     * 预约人姓名（商品类型为CXA商品时有值）
     */
    private String appointmentName;

    /**
     * 预约人手机号（商品类型为CXA商品时有值）
     */
    private String appointmentPhone;

    /**
     * 预约时间（商品类型为CXA商品时有值）
     */
    private Date appointmentTime;

    /**
     * 商品名称
     */
    private String itemName;

    /**
     * 收货地址信息
     */
    private DuiBaOrderDetailReceiveAddrInfoVo receiveAddrInfo;

    // Getters and Setters

    /**
     * 收货地址的内部类
     */
    public static class DuiBaOrderDetailReceiveAddrInfoVo {

        /**
         * 省
         */
        private String province;

        /**
         * 市
         */
        private String city;

        /**
         * 区
         */
        private String area;

        /**
         * 街道
         */
        private String street;

        /**
         * 详细地址
         */
        private String address;

        /**
         * 收货人手机号
         */
        private String mobile;

        /**
         * 收货人姓名
         */
        private String name;

        public String getProvince() {
            return province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String getCity() {
            return city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getArea() {
            return area;
        }

        public void setArea(String area) {
            this.area = area;
        }

        public String getStreet() {
            return street;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public String getAddress() {
            return address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getMobile() {
            return mobile;
        }

        public void setMobile(String mobile) {
            this.mobile = mobile;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(String appItemId) {
        this.appItemId = appItemId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getHsbcOrderId() {
        return hsbcOrderId;
    }

    public void setHsbcOrderId(String hsbcOrderId) {
        this.hsbcOrderId = hsbcOrderId;
    }

    public String getPlaceCode() {
        return placeCode;
    }

    public void setPlaceCode(String placeCode) {
        this.placeCode = placeCode;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getConsumerPayPrice() {
        return consumerPayPrice;
    }

    public void setConsumerPayPrice(String consumerPayPrice) {
        this.consumerPayPrice = consumerPayPrice;
    }

    public String getOrderUrl() {
        return orderUrl;
    }

    public void setOrderUrl(String orderUrl) {
        this.orderUrl = orderUrl;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDeliveryCompanyNo() {
        return deliveryCompanyNo;
    }

    public void setDeliveryCompanyNo(String deliveryCompanyNo) {
        this.deliveryCompanyNo = deliveryCompanyNo;
    }

    public String getDeliveryCompanyName() {
        return deliveryCompanyName;
    }

    public void setDeliveryCompanyName(String deliveryCompanyName) {
        this.deliveryCompanyName = deliveryCompanyName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getCardBeginTime() {
        return cardBeginTime;
    }

    public void setCardBeginTime(Long cardBeginTime) {
        this.cardBeginTime = cardBeginTime;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getCardEndTime() {
        return cardEndTime;
    }

    public void setCardEndTime(Long cardEndTime) {
        this.cardEndTime = cardEndTime;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getAppointmentName() {
        return appointmentName;
    }

    public void setAppointmentName(String appointmentName) {
        this.appointmentName = appointmentName;
    }

    public String getAppointmentPhone() {
        return appointmentPhone;
    }

    public void setAppointmentPhone(String appointmentPhone) {
        this.appointmentPhone = appointmentPhone;
    }

    public Date getAppointmentTime() {
        return appointmentTime;
    }

    public void setAppointmentTime(Date appointmentTime) {
        this.appointmentTime = appointmentTime;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public DuiBaOrderDetailReceiveAddrInfoVo getReceiveAddrInfo() {
        return receiveAddrInfo;
    }

    public void setReceiveAddrInfo(DuiBaOrderDetailReceiveAddrInfoVo receiveAddrInfo) {
        this.receiveAddrInfo = receiveAddrInfo;
    }
}
