package cn.com.duiba.thirdparty.dto.kouweiwang;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 口味王订单同步对象
 *
 * @author fja
 */
public class KwwOrderSyncDto implements Serializable {
    private static final long serialVersionUID = -4774095628991091943L;

    @JSONField(name = "userId")
    private String partnerUserId;

    @JSONField(name = "orderNo")
    private String orderNum;

    private String orderType;

    private Long orderPrice;

    private String status = "00";

    private Long credits;

    @JSONField(name = "orderDate", format = "yyyy-MM-dd HH:mm:ss")
    private Date gmtCreate;

    private String receiverAddrId;

    private List<KwwOrderItem> rows;

    private String msg;

    private String remark;

    private String activityId;

    private String activityName;

    /**
     * 品牌渠道来源
     * 口味王：kww
     * 和成天下：hctx
     * 不传默认是kww
     */
    private String channel;

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public Long getOrderPrice() {
        return orderPrice;
    }

    public void setOrderPrice(Long orderPrice) {
        this.orderPrice = orderPrice;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getReceiverAddrId() {
        return receiverAddrId;
    }

    public void setReceiverAddrId(String receiverAddrId) {
        this.receiverAddrId = receiverAddrId;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public List<KwwOrderItem> getRows() {
        return rows;
    }

    public void setRows(List<KwwOrderItem> rows) {
        this.rows = rows;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public static class KwwOrderItem implements Serializable{
        private static final long serialVersionUID = -7030848103241096802L;

        @JSONField(name = "skuNo")
        private String id;

        @JSONField(name = "skuType")
        private Integer type;

        @JSONField(name = "skuName")
        private String title;

        @JSONField(name = "number")
        private Integer quantity;

        private Long credits;

        private String url;

        private Integer balanceStock;

        @JSONField(name = "sellPrice")
        private Long price;

        private String remark;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Integer getQuantity() {
            return quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public Long getCredits() {
            return credits;
        }

        public void setCredits(Long credits) {
            this.credits = credits;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Integer getBalanceStock() {
            return balanceStock;
        }

        public void setBalanceStock(Integer balanceStock) {
            this.balanceStock = balanceStock;
        }

        public Long getPrice() {
            return price;
        }

        public void setPrice(Long price) {
            this.price = price;
        }

        public String getRemark() {
            return remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }
    }
}
