package cn.com.duiba.thirdparty.dto.wdt;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;

import java.io.Serializable;
import java.util.List;

/**
 * @author duiba
 */
@JSONType(orders = {"shopNo","rawTradeList","rawTradeOrderList","discountList"})
public class OrderPushParam implements Serializable {

    private static final long serialVersionUID = -7803424103875032412L;
    /**
     * 店铺编号
     */
    @JSONField(name = "shop_no")
    private String shopNo;

    /**
     * 原始单信息
     */
    private List<RawTrade> rawTradeList;

    /**
     * 原始子单信息
     */
    private List<RawTradeOrder> rawTradeOrderList;


    public String getShopNo() {
        return shopNo;
    }

    public void setShopNo(String shopNo) {
        this.shopNo = shopNo;
    }

    public List<RawTrade> getRawTradeList() {
        return rawTradeList;
    }

    public void setRawTradeList(List<RawTrade> rawTradeList) {
        this.rawTradeList = rawTradeList;
    }

    public List<RawTradeOrder> getRawTradeOrderList() {
        return rawTradeOrderList;
    }

    public void setRawTradeOrderList(List<RawTradeOrder> rawTradeOrderList) {
        this.rawTradeOrderList = rawTradeOrderList;
    }
}
