package cn.com.duiba.thirdparty.dto.wdt;

import java.io.Serializable;

public class OrderQueryParam  implements Serializable {

    private static final long serialVersionUID = 2479758747004155801L;
    /**
     * 可以多个状态通过逗号拼接
     */
    private String status;

    /**
     * 查询开始时间
     */
    private String startTime;

    /**
     * 查询结束时间
     */
    private String endTime;

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static final byte STATUS_OFFLINE_REFUND = 4; // 线下退款
    public static final byte STATUS_CANCEL = 5; // 已取消
    public static final byte STATUS_TO_PRECHECK = 6;// 待确认，待转预订单
    public static final byte STATUS_TO_COMPLETED = 7; // 待确认订单
    public static final byte STATUS_WAIT_TO_PAY = 10; // 待付款
    public static final byte STATUS_PART_PAID = 12; // 待尾款
    public static final byte STATUS_WAIT_UNPAY = 15; // 等未付
    public static final byte STATUS_DELAY_TO_CHECK = 16; // 延时审核
    public static final byte STATUS_PREV_PREORDER = 19; // 预订单前处理
    public static final byte STATUS_PREV_CHECK = 20; // 前处理(赠品，合并，拆分)
    public static final byte STATUS_EXCEPTION = 23; // 异常预订单
    public static final byte STATUS_PREORDER_EXCHANGE = 24; // 换货预订单
    public static final byte STATUS_PREORDER_HANDLING = 25; // 待处理预订单
    public static final byte STATUS_PREORDER_ACTIVATING = 26; // 待激活预订单
    public static final byte STATUS_PREORDER_QUEUE = 27; // 待分配预订单
    public static final byte STATUS_WAIT_CHECK = 30; // 待审核
    public static final byte STATUS_WAIT_FINCHECK = 35; // 待财审
    public static final byte STATUS_WMS_CONFIRMED = 55; // 已确认,已生成出库单
    public static final byte STATUS_CONSIGNED = 95; // 已发货
    public static final byte STATUS_NO_PLANNED_COST = 96;// 待录入计划成本，订单结算时有货品无计划成本
    public static final byte STATUS_POSTED = 101;// 已过账
    public static final byte STATUS_COMPLETE = 110; // 已完成

}
