package cn.com.duiba.thirdparty.api.huaxizi;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AmbPostsaleOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.PostsaleExpressDto;
import cn.com.duiba.thirdparty.dto.huaxizi.HuaXiZiCreditsResultDTO;
import cn.com.duiba.thirdparty.dto.huaxizi.HuaXiZiUserDto;
import cn.com.duiba.thirdparty.dto.huaxizi.QueryUserCreditsParam;
import cn.com.duiba.thirdparty.dto.huaxizi.QueryUserParam;

/**
 * 花西子服务接口
 */
@AdvancedFeignClient
public interface RemoteHuaXiZiService {

    /**
     * 查询用户信息
     * @param param
     * @return
     */
    HuaXiZiUserDto getUserInfo(QueryUserParam param) throws BizException;


    /**
     * 售后订单推送
     * @param postsaleOrder
     * @throws BizException
     */
    void postSaleSubmitOrderPush(AmbPostsaleOrdersDto postsaleOrder, PostsaleExpressDto postsaleExpressDto) throws BizException;

    /**
     * 花西子退款推送
     *
     * @param order 订单信息
     * @param reason 退款原因
     * @throws BizException -
     */
    void closeOrderPush(OrdersDto order, String reason) throws BizException;

    /**
     * 售后订单完成/取消
     * @param postsaleOrder
     * @throws BizException
     */
    @Deprecated
    void postSaleCloseOrderPush(AmbPostsaleOrdersDto postsaleOrder) throws BizException;


    /**
     * 查询用户积分信息
     * @param param
     * @return
     * @throws BizException
     */
    HuaXiZiCreditsResultDTO queryHuaXiZiCreditsDetail(QueryUserCreditsParam param) throws BizException;

    /**
     * 花西子订单同步
     * @param order
     * @param orderStatus
     */
    void orderExec(OrdersDto order, String orderStatus);

    /**
     * 售后订单完成/取消
     * 退单状态：WAIT_SELLER_AGREE：买家已经申请退款，等待卖家同意，SELLER_REFUSE_BUYER：卖家拒绝退款，CLOSED：退款关闭，SUCCESS：退款成功，FAILED:退款失败，REFUND_PROCESSING：正在退款中
     * @param postsaleOrder
     * @throws BizException
     */
    void postSaleCloseOrderPushWithStatus(AmbPostsaleOrdersDto postsaleOrder,String status) throws BizException;
}
