/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.thirdparty.util.huaxizi;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlUtil {
    public static final String EN_US = "en_US";
    public static final String ZH_CN = "zh_CN";

    public static UrlEntity parse(String url) {
        UrlEntity entity = new UrlEntity();
        if (url == null) {
            return entity;
        }
        if ((url = url.trim()).equals("")) {
            return entity;
        }
        String[] urlParts = url.split("\\?");
        entity.baseUrl = urlParts[0];
        if (urlParts.length == 1) {
            return entity;
        }
        String[] params = urlParts[1].split("&");
        entity.params = new HashMap();
        for (String param : params) {
            String[] keyValue = param.split("=");
            entity.params.put(keyValue[0], keyValue.length > 1 ? keyValue[1] : "");
        }
        return entity;
    }

    public static String getParam(String url, String name) {
        String params = url.substring(url.indexOf("?") + 1, url.length());
        Map split = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)params);
        return (String)split.get(name);
    }

    public static String getParamByQueryString(String queryString, String name) {
        return UrlUtil.getParamByQueryString(queryString).get(name);
    }

    public static Map<String, String> getParamByQueryString(String queryString) {
        Map split = !Strings.isNullOrEmpty((String)queryString) ? Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)queryString) : Maps.newHashMap();
        return split;
    }

    public static Map<String, String> getParamByUrl(String URL2) {
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        String[] arrSplit = null;
        String strUrlParam = UrlUtil.TruncateUrlPage(URL2);
        if (strUrlParam == null) {
            return mapRequest;
        }
        for (String strSplit : arrSplit = strUrlParam.split("[&]")) {
            String[] arrSplitEqual = null;
            arrSplitEqual = strSplit.split("[=]");
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);
                continue;
            }
            if (arrSplitEqual[0] == "") continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return mapRequest;
    }

    private static String TruncateUrlPage(String strURL) {
        String strAllParam = null;
        String[] arrSplit = null;
        strURL = strURL.trim();
        arrSplit = strURL.split("[?]");
        if (strURL.length() > 1 && arrSplit.length > 1 && arrSplit[1] != null) {
            strAllParam = arrSplit[1];
        }
        return strAllParam;
    }

    public static String TruncateUrl(String strURL) {
        String strAllParam = null;
        String[] arrSplit = null;
        strURL = strURL.trim();
        arrSplit = strURL.split("[?]");
        if (strURL.length() > 1 && arrSplit.length > 1 && arrSplit[0] != null) {
            strAllParam = arrSplit[0];
        }
        return strAllParam;
    }

    public static int isUrlIncludeParam(String urlStr, String param) {
        Map<String, String> map = UrlUtil.getParamByUrl(urlStr);
        if (null == map || map.size() == 0) {
            return 0;
        }
        if (map.containsKey(param)) {
            if (null != map.get(param) && !"".equals(map.get(param))) {
                return 1;
            }
            return 2;
        }
        return 3;
    }

    public static String getUrlIncludeParam(String urlStr, String param) {
        Map<String, String> map = UrlUtil.getParamByUrl(urlStr);
        if (null == map || map.size() == 0) {
            return "";
        }
        if (map.containsKey(param)) {
            return map.get(param);
        }
        return "";
    }

    public static String jointUrl(String urlStr, String param, String value) {
        if (Strings.isNullOrEmpty((String)urlStr) || Strings.isNullOrEmpty((String)param) || Strings.isNullOrEmpty((String)value)) {
            return urlStr;
        }
        int type = UrlUtil.isUrlIncludeParam(urlStr, param);
        StringBuilder url = new StringBuilder();
        switch (type) {
            case 0: {
                url.append(urlStr);
                url.append("?");
                url.append(param);
                url.append("=");
                url.append(value);
                break;
            }
            case 1: {
                url.append(urlStr);
                break;
            }
            case 2: {
                url.append(UrlUtil.TruncateUrl(urlStr));
                Map<String, String> map = UrlUtil.getParamByUrl(urlStr);
                int i = 0;
                for (Map.Entry<String, String> m : map.entrySet()) {
                    if (i == 0) {
                        url.append("?");
                    } else {
                        url.append("&");
                    }
                    if (!m.getKey().equals(param)) {
                        url.append(m.getKey());
                        url.append("=");
                        url.append(m.getValue());
                    } else {
                        url.append(m.getKey());
                        url.append("=");
                        url.append(value);
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                url.append(urlStr);
                url.append("&");
                url.append(param);
                url.append("=");
                url.append(value);
            }
        }
        return url.toString();
    }

    public static String appendUrl(String url, Map<String, Object> paramMap) {
        String newUrl = url;
        StringBuffer param = new StringBuffer();
        for (String key : paramMap.keySet()) {
            param.append(key + "=" + paramMap.get(key).toString() + "&");
        }
        String paramStr = param.toString();
        paramStr = paramStr.substring(0, paramStr.length() - 1);
        newUrl = newUrl.contains("?") ? newUrl + "&" + paramStr : newUrl + "?" + paramStr;
        return newUrl;
    }

    public static String getParamByUrl(String url, String name) {
        url = url + "&";
        String pattern = "(\\?|&){1}#{0,1}" + name + "=[^&]*(&{1})";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(url);
        if (m.find()) {
            return m.group(0).split("=")[1].replace("&", "");
        }
        return null;
    }

    public static class UrlEntity {
        private String baseUrl;
        private Map<String, String> params;

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public Map<String, String> getParams() {
            return Collections.unmodifiableMap(this.params);
        }
    }
}

