package cn.com.duiba.thirdparty.api.qiyu;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdparty.dto.qiyu.*;

/**
 * 七鱼客服服务
 */
@AdvancedFeignClient
public interface RemoteQiYuCustomerUatService {

	/**
	 * 请求分配客服
	 * @param applyStaffDto
	 * @return
	 */
	StaffMessageDto applyStaff(ApplyStaffDto applyStaffDto);


	/**
	 * 发送会话消息
	 * @return
	 */
	QiYuResultDto messageSend(String uid, String type, String content);

	/**
	 * 修改用户资料
	 * 主要是在分配客服之后使用
	 * @param qiUserParam
	 */
	void updateUserInfo(QiUserParam qiUserParam);


	/**
	 * 主动退出排队
	 * @param uid
	 * @return
	 */
	QiYuResultDto quitQueue(String uid);

	/**
	 * 查询队伍排列状态
	 * @param uid
	 * @return
	 */
	QiYuKfQueueDto queryQueueStatus(String uid);

	/**
	 * 验签
	 * @param md5
	 * @param time
	 * @param checksumSign
	 * @return
	 */
	Boolean checkSign(String md5, Long time, String checksumSign);
}
