package cn.com.duiba.thirdparty.dto.hsbc;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: fss
 * @Date: 2022/10/10 18
 * @Description:
 */
public class HsbcConsumerAmountDto implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 红包余额
     */
    private BigDecimal redEnvelopeBalance;

    /**
     * 红包余额:分
     */
    private Long redEnvelopeBalanceLong;

    /**
     * 风险等级
     *
     * @see cn.com.duiba.thirdparty.enums.hsbc.UserRiskLevelEnum
     */
    private String userRiskLevel;
    /**
     * 用户可用积分数
     */
    private Integer pointsBalance;
    /**
     * 用户积分账户状态
     * <p>
     * 1:账户正常，2:严格冻结(无法获取和使用积分)
     * <p>
     * 3:账户无效
     * <p>
     * 4:非严格冻结（可获取，不可使用）
     */
    private Integer accountStatus;

    /**
     * 用户会员等级
     */
    private Integer vipLevel;

    /**
     * 头像链接
     */
    private String profilePhotoLink;
    /**
     * 手机尾号后四位
     */
    private String phoneTailNumber;


    public Integer getPointsBalance() {
        return pointsBalance;
    }

    public void setPointsBalance(Integer pointsBalance) {
        this.pointsBalance = pointsBalance;
    }

    public Integer getAccountStatus() {
        return accountStatus;
    }

    public void setAccountStatus(Integer accountStatus) {
        this.accountStatus = accountStatus;
    }

    public Integer getVipLevel() {
        return vipLevel;
    }

    public void setVipLevel(Integer vipLevel) {
        this.vipLevel = vipLevel;
    }

    public String getProfilePhotoLink() {
        return profilePhotoLink;
    }

    public void setProfilePhotoLink(String profilePhotoLink) {
        this.profilePhotoLink = profilePhotoLink;
    }

    public String getPhoneTailNumber() {
        return phoneTailNumber;
    }

    public void setPhoneTailNumber(String phoneTailNumber) {
        this.phoneTailNumber = phoneTailNumber;
    }

    public Long getRedEnvelopeBalanceLong() {
        return redEnvelopeBalanceLong;
    }

    public void setRedEnvelopeBalanceLong(Long redEnvelopeBalanceLong) {
        this.redEnvelopeBalanceLong = redEnvelopeBalanceLong;
    }

    public BigDecimal getRedEnvelopeBalance() {
        return redEnvelopeBalance;
    }

    public void setRedEnvelopeBalance(BigDecimal redEnvelopeBalance) {
        this.redEnvelopeBalance = redEnvelopeBalance;
    }

    public String getUserRiskLevel() {
        return userRiskLevel;
    }

    public void setUserRiskLevel(String userRiskLevel) {
        this.userRiskLevel = userRiskLevel;
    }
}
