package cn.com.duiba.thirdparty.dto.wdt;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

public class RawTrade implements Serializable {

    private static final long serialVersionUID = -8643698515347153058L;

    @JSONField(name = "delivery_term")
    private int deliveryTerm = DELIVERY_TERM_DAP;


    @JSONField(name = "refund_status")
    private byte refundStatus = REFUND_NONE;


    /**
     * 平台状态
     */
    @JSONField(name = "trade_status")
    private byte tradeStatus = TRADE_STATUS_WAIT_CONSIGN;

    @JSONField(name = "pay_status")
    private byte payStatus = PAY_STATUS_FULL_PAID;

    /**
     * 原始状态
     */
    @JSONField(name = "process_status")
    private byte processStatus = PROCESS_STATUS_WAIT_DELIVERY;

    /**
     * 原始单号
     */
    private String tid;
    // !!!
    @JSONField(name = "is_auto_wms")
    private Boolean autoWms;

    @JSONField(name = "warehouse_no")
    private String warehouseNo;

    @JSONField(name = "goods_count")
    private String goodsCount = "0.0000";

    /**
     * 子订单个数
     */
    @JSONField(name = "order_count")
    private Integer orderCount = 0;

    @JSONField(name = "trade_time")
    private String tradeTime;

    @JSONField(name = "consign_interval")
    private Integer consignInterval;

    @JSONField(name = "to_deliver_time")
    private String toDeliverTime;

    @JSONField(name = "platform_cost")
    private String platformCost;

    @JSONField(name = "logistics_type")
    private Integer logisticsType;

    @JSONField(name = "end_time")
    private String endTime;

    @JSONField(name = "pay_time")
    private String payTime;

    @JSONField(name = "goods_count")
    private Byte payMethod;

    @JSONField(name = "pay_account")
    private String payAccount = "";

    @JSONField(name = "receiver_zip")
    private String receiverZip = "";

    @JSONField(name = "receiver_telno")
    private String receiverTelno = "";

    @JSONField(name = "receiver_name")
    private String receiverName = "";

    @JSONField(name = "receiver_area")
    private String receiverArea = "";

    @JSONField(name = "receiver_mobile")
    private String receiverMobile = "";

    @JSONField(name = "receiver_address")
    private String receiverAddress = "";

    @JSONField(name = "buyer_nick")
    private String buyerNick = "";

    @JSONField(name = "buyer_email")
    private String buyerEmail = "";

    @JSONField(name = "buyer_message")
    private String buyerMessage = "";

    @JSONField(name = "buyer_area")
    private String buyerArea = "";
    @JSONField(name = "invoice_type")
    private Byte invoiceType;

    @JSONField(name = "invoice_content")
    private String invoiceContent = "";

    @JSONField(name = "invoice_title")
    private String invoiceTitle = "";

    @JSONField(name = "remark_flag")
    private Integer remark_flag;

    private String remark = "";

    @JSONField(name = "pay_id")
    private String pay_id = "";

    @JSONField(name = "receivable")
    private String receivable = "0"; // 应收金额

    @JSONField(name = "post_amount")
    private String postAmount = "0"; // 邮费

    @JSONField(name = "discount")
    private String discount = "0"; // 折扣

    private String received = "0"; // 已收金额

    @JSONField(name = "cod_amount")
    private String codAmount = "0"; // COD金额

    @JSONField(name = "other_amount")
    private String otherAmount = "0"; // 其他费用

    /**
     * 平台状态 未确认
     */
    public static final byte TRADE_STATUS_TO_CONFIRM = 10;
    /**
     * 平台状态 待尾款
     */
    public static final byte TRADE_STATUS_PART_PAID = 20;
    /**
     * 平台状态 待发货
     */
    public static final byte TRADE_STATUS_WAIT_CONSIGN = 30;
    /**
     * 平台状态 部分发货
     */
    public static final byte TRADE_STATUS_PART_CONSIGN = 40;
    /**
     * 平台状态 已发货
     */
    public static final byte TRADE_STATUS_CONSIGNED = 50;
    /**
     * 平台状态 已签收
     */
    public static final byte TRADE_STATUS_SIGNED = 60;
    /**
     * 平台状态 已完成
     */
    public static final byte TRADE_STATUS_COMPLETE = 70;
    /**
     * 平台状态 已退款
     */
    public static final byte TRADE_STATUS_REFUND = 80;
    /**
     * 平台状态 已关闭(付款前取消)
     */
    public static final byte TRADE_STATUS_CLOSED = 90;

    // 付款状态
    public static final byte PAY_STATUS_UNPAY = 0; // 未付款
    public static final byte PAY_STATUS_PART_PAID = 1; // 部分付款
    public static final byte PAY_STATUS_FULL_PAID = 2; // 已付款

    // 退款状态
    public static final byte REFUND_NONE = 0; // 无退款
    public static final byte REFUND_APPLY = 1; // 申请退款
    public static final byte REFUND_PART = 2; // 部分退款
    public static final byte REFUND_FULL = 3; // 全部退款

    /**
     * * 款到发货
     */
    public static final byte DELIVERY_TERM_DAP = 1; // 款到发货
    /**
     * 货到付款
     */
    public static final byte DELIVERY_TERM_COD = 2; // 货到付款(包含部分货到付款)

    public static final byte PROCESS_STATUS_WAIT_DELIVERY = 10; // 待递交
    public static final byte PROCESS_STATUS_CANCEL = 70; // 已取消

    // 1在线转帐 2现金，3银行转账，4邮局汇款 5预付款 6刷卡
    public static final byte PAY_METHOD_ONLINE = 1;
    public static final byte PAY_METHOD_CASH = 2;
    public static final byte PAY_METHOD_BANK = 3;
    public static final byte PAY_METHOD_REMITTANCE = 4;
    public static final byte PAY_METHOD_ADVANCES = 5;
    public static final byte PAY_METHOD_CARD = 5;

    // 0 不需要，1普通发票，2增值税发票
    public static final byte INVOICE_TYPE_NONE = 0;
    public static final byte INVOICE_TYPE_ORDINARY = 1;
    public static final byte INVOICE_TYPE_VAT = 2;

    public int getDeliveryTerm() {
        return deliveryTerm;
    }

    public void setDeliveryTerm(int deliveryTerm) {
        this.deliveryTerm = deliveryTerm;
    }

    public byte getRefundStatus() {
        return refundStatus;
    }

    public void setRefundStatus(byte refundStatus) {
        this.refundStatus = refundStatus;
    }

    public byte getTradeStatus() {
        return tradeStatus;
    }

    public void setTradeStatus(byte tradeStatus) {
        this.tradeStatus = tradeStatus;
    }

    public byte getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(byte payStatus) {
        this.payStatus = payStatus;
    }

    public byte getProcessStatus() {
        return processStatus;
    }

    public void setProcessStatus(byte processStatus) {
        this.processStatus = processStatus;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public Boolean getAutoWms() {
        return autoWms;
    }

    public void setAutoWms(Boolean autoWms) {
        this.autoWms = autoWms;
    }

    public String getWarehouseNo() {
        return warehouseNo;
    }

    public void setWarehouseNo(String warehouseNo) {
        this.warehouseNo = warehouseNo;
    }

    public String getGoodsCount() {
        return goodsCount;
    }

    public void setGoodsCount(String goodsCount) {
        this.goodsCount = goodsCount;
    }

    public Integer getOrderCount() {
        return orderCount;
    }

    public void setOrderCount(Integer orderCount) {
        this.orderCount = orderCount;
    }

    public String getTradeTime() {
        return tradeTime;
    }

    public void setTradeTime(String tradeTime) {
        this.tradeTime = tradeTime;
    }

    public Integer getConsignInterval() {
        return consignInterval;
    }

    public void setConsignInterval(Integer consignInterval) {
        this.consignInterval = consignInterval;
    }

    public String getToDeliverTime() {
        return toDeliverTime;
    }

    public void setToDeliverTime(String toDeliverTime) {
        this.toDeliverTime = toDeliverTime;
    }

    public String getPlatformCost() {
        return platformCost;
    }

    public void setPlatformCost(String platformCost) {
        this.platformCost = platformCost;
    }

    public Integer getLogisticsType() {
        return logisticsType;
    }

    public void setLogisticsType(Integer logisticsType) {
        this.logisticsType = logisticsType;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getPayTime() {
        return payTime;
    }

    public void setPayTime(String payTime) {
        this.payTime = payTime;
    }

    public Byte getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(Byte payMethod) {
        this.payMethod = payMethod;
    }

    public String getPayAccount() {
        return payAccount;
    }

    public void setPayAccount(String payAccount) {
        this.payAccount = payAccount;
    }

    public String getReceiverZip() {
        return receiverZip;
    }

    public void setReceiverZip(String receiverZip) {
        this.receiverZip = receiverZip;
    }

    public String getReceiverTelno() {
        return receiverTelno;
    }

    public void setReceiverTelno(String receiverTelno) {
        this.receiverTelno = receiverTelno;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getReceiverArea() {
        return receiverArea;
    }

    public void setReceiverArea(String receiverArea) {
        this.receiverArea = receiverArea;
    }

    public String getReceiverMobile() {
        return receiverMobile;
    }

    public void setReceiverMobile(String receiverMobile) {
        this.receiverMobile = receiverMobile;
    }

    public String getReceiverAddress() {
        return receiverAddress;
    }

    public void setReceiverAddress(String receiverAddress) {
        this.receiverAddress = receiverAddress;
    }

    public String getBuyerNick() {
        return buyerNick;
    }

    public void setBuyerNick(String buyerNick) {
        this.buyerNick = buyerNick;
    }

    public String getBuyerEmail() {
        return buyerEmail;
    }

    public void setBuyerEmail(String buyerEmail) {
        this.buyerEmail = buyerEmail;
    }

    public String getBuyerMessage() {
        return buyerMessage;
    }

    public void setBuyerMessage(String buyerMessage) {
        this.buyerMessage = buyerMessage;
    }

    public String getBuyerArea() {
        return buyerArea;
    }

    public void setBuyerArea(String buyerArea) {
        this.buyerArea = buyerArea;
    }

    public Byte getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Byte invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceContent() {
        return invoiceContent;
    }

    public void setInvoiceContent(String invoiceContent) {
        this.invoiceContent = invoiceContent;
    }

    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public String getReceivable() {
        return receivable;
    }

    public void setReceivable(String receivable) {
        this.receivable = receivable;
    }

    public String getPostAmount() {
        return postAmount;
    }

    public void setPostAmount(String postAmount) {
        this.postAmount = postAmount;
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public String getReceived() {
        return received;
    }

    public void setReceived(String received) {
        this.received = received;
    }

    public String getCodAmount() {
        return codAmount;
    }

    public void setCodAmount(String codAmount) {
        this.codAmount = codAmount;
    }

    public String getOtherAmount() {
        return otherAmount;
    }

    public void setOtherAmount(String otherAmount) {
        this.otherAmount = otherAmount;
    }

    public Integer getRemark_flag() {
        return remark_flag;
    }

    public void setRemark_flag(Integer remark_flag) {
        this.remark_flag = remark_flag;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getPay_id() {
        return pay_id;
    }

    public void setPay_id(String pay_id) {
        this.pay_id = pay_id;
    }
}
