package cn.com.duiba.thirdparty.duibacornucopia;

import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @author zzy
 * @create 2023/12/18 17:26
 **/
public class DuiBaCornucopiaOrderBizDataBo implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * 券包商品标记，券包商品时固定为true
     */
    private Boolean goodsPkgFlag;

    /**
     * 券包主订单状态
     */
    private Integer mainOrderStatus;
    /**
     * 券包主订单号
     */
    private String mainOrderNum;

    /**
     * 券包子订单数据
     */
    private List<SubOrderData> subOrderDataList;

    /**
     * 错误码
     */
    private String failCode;

    /**
     * 错误描述
     */
    private String failDesc;

    /**
     * 三方订单号，下单时传递，兑吧透传返回
     */
    private String thirdOrderId;

    /**
     * 开发者自有参数，兑吧透传返回
     */
    private String remark;

    /**
     * 链接券类型
     */
    private Integer linkType;

    /**
     * 公众号H5静默授权领取链接
     */
    private String oaLink;

    /**
     * 小程序H5唤起授权领取链接
     */
    private String mpLink;

    /**
     * 小程序AppID
     */
    private String mpAppId;

    /**
     * 小程序Path
     */
    private String mpPath;

    /**
     * 支付宝领取链接
     */
    private String alipayLink;

    /**
     * 卡密类型
     */
    private Integer kmType;

    /**
     * 卡密code
     */
    private String kmCode;

    /**
     * 卡密密码
     */
    private String kmPassword;

    /**
     * 卡密链接
     */
    private String kmLink;

    /**
     * 消费时间
     */
    private Long consumeTime;

    /**
     * 交易流水号
     */
    private String transactionId;

    /**
     * 优惠券id，微信/支付宝券id
     */
    private String couponId;

    /**
     * 过期时间
     */
    private Long expireTime;

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public Boolean getGoodsPkgFlag() {
        return goodsPkgFlag;
    }

    public void setGoodsPkgFlag(Boolean goodsPkgFlag) {
        this.goodsPkgFlag = goodsPkgFlag;
    }

    public Integer getMainOrderStatus() {
        return mainOrderStatus;
    }

    public void setMainOrderStatus(Integer mainOrderStatus) {
        this.mainOrderStatus = mainOrderStatus;
    }

    public String getMainOrderNum() {
        return mainOrderNum;
    }

    public void setMainOrderNum(String mainOrderNum) {
        this.mainOrderNum = mainOrderNum;
    }

    public List<SubOrderData> getSubOrderDataList() {
        return subOrderDataList;
    }

    public void setSubOrderDataList(List<SubOrderData> subOrderDataList) {
        this.subOrderDataList = subOrderDataList;
    }

    public String getFailCode() {
        return failCode;
    }

    public String getFailDesc() {
        return failDesc;
    }

    public String getThirdOrderId() {
        return thirdOrderId;
    }

    public void setThirdOrderId(String thirdOrderId) {
        this.thirdOrderId = thirdOrderId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getLinkType() {
        return linkType;
    }

    public void setLinkType(Integer linkType) {
        this.linkType = linkType;
    }

    public String getOaLink() {
        return oaLink;
    }

    public void setOaLink(String oaLink) {
        this.oaLink = oaLink;
    }

    public String getMpLink() {
        return mpLink;
    }

    public void setMpLink(String mpLink) {
        this.mpLink = mpLink;
    }

    public String getMpAppId() {
        return mpAppId;
    }

    public void setMpAppId(String mpAppId) {
        this.mpAppId = mpAppId;
    }

    public String getMpPath() {
        return mpPath;
    }

    public void setMpPath(String mpPath) {
        this.mpPath = mpPath;
    }

    public String getAlipayLink() {
        return alipayLink;
    }

    public void setAlipayLink(String alipayLink) {
        this.alipayLink = alipayLink;
    }

    public Integer getKmType() {
        return kmType;
    }

    public void setKmType(Integer kmType) {
        this.kmType = kmType;
    }

    public String getKmCode() {
        return kmCode;
    }

    public void setKmCode(String kmCode) {
        this.kmCode = kmCode;
    }

    public String getKmPassword() {
        return kmPassword;
    }

    public void setKmPassword(String kmPassword) {
        this.kmPassword = kmPassword;
    }

    public String getKmLink() {
        return kmLink;
    }

    public void setKmLink(String kmLink) {
        this.kmLink = kmLink;
    }

    public Long getConsumeTime() {
        return consumeTime;
    }

    public void setConsumeTime(Long consumeTime) {
        this.consumeTime = consumeTime;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getCouponId() {
        return couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public Long getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Long expireTime) {
        this.expireTime = expireTime;
    }

    public void setFailCode(String failCode) {
        this.failCode = StringUtils.trimToNull(failCode);
    }

    public void setFailDesc(String failDesc) {
        this.failDesc = StringUtils.trimToNull(failDesc);
    }

    public static class SubOrderData implements Serializable {
        private static final long serialVersionUID = 4779697378459315557L;

        /**
         * 券包子订单号
         */
        private String subOrderNum;

        /**
         * 券包子订单状态
         */
        private String subOrderStatus;
        /**
         * 错误码
         */
        private String failCode;

        /**
         * 错误描述
         */
        private String failDesc;
        /**
         * 消费时间
         */
        private Long consumeTime;

        /**
         * 交易流水号
         */
        private String transactionId;

        /**
         * 优惠券id，微信/支付宝券id
         */
        private String couponId;

        /**
         * 过期时间
         */
        private Long expireTime;

        public String getSubOrderNum() {
            return subOrderNum;
        }

        public void setSubOrderNum(String subOrderNum) {
            this.subOrderNum = subOrderNum;
        }

        public String getSubOrderStatus() {
            return subOrderStatus;
        }

        public void setSubOrderStatus(String subOrderStatus) {
            this.subOrderStatus = subOrderStatus;
        }

        public String getFailCode() {
            return failCode;
        }

        public void setFailCode(String failCode) {
            this.failCode = failCode;
        }

        public String getFailDesc() {
            return failDesc;
        }

        public void setFailDesc(String failDesc) {
            this.failDesc = failDesc;
        }

        public Long getConsumeTime() {
            return consumeTime;
        }

        public void setConsumeTime(Long consumeTime) {
            this.consumeTime = consumeTime;
        }

        public String getTransactionId() {
            return transactionId;
        }

        public void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public String getCouponId() {
            return couponId;
        }

        public void setCouponId(String couponId) {
            this.couponId = couponId;
        }

        public Long getExpireTime() {
            return expireTime;
        }

        public void setExpireTime(Long expireTime) {
            this.expireTime = expireTime;
        }
    }
}
