/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.credits.AddCreditsToDeveloper;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.service.HttpAsyncClientPool;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AddCreditsRetryJob
extends AbstractSimpleElasticJob {
    private Logger log = LoggerFactory.getLogger(AddCreditsRetryJob.class);
    @Value(value="${notifycenter.timer.enable}")
    private boolean timerEnable;
    @Autowired
    private HttpMessageDAO httpMessageDAO;
    @Autowired
    private AddCreditsToDeveloper addCreditsToDeveloper;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    public void process(JobExecutionMultipleShardingContext shardingContext) {
        if (!this.timerEnable) {
            return;
        }
        long s = System.currentTimeMillis();
        List<HttpMessageDO> dos = this.httpMessageDAO.findNeedRetry("addCredits", 2000);
        for (HttpMessageDO db : dos) {
            if (this.httpAsyncClientPool.canSubmitToAppPool(db.getAppId().toString())) {
                this.addCreditsToDeveloper.submit(db);
                continue;
            }
            this.log.warn("scan cannot be submit to " + db.getAppId() + " queue");
        }
        long e = System.currentTimeMillis();
        this.log.info("addCredits scan size:" + dos.size() + " time:" + (e - s) + "ms");
    }
}

