/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.HttpRetryRulesService;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AddCreditsToDeveloper {
    private static final Logger LOG = LoggerFactory.getLogger(AddCreditsToDeveloper.class);
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private MessageService messageService;
    @Autowired
    private HttpRetryRulesService httpRetryRulesService;
    @Autowired
    private HttpMessageDAO httpMessageDAO;
    @Autowired
    private CustomService customService;

    public void submit(final HttpMessageDO message) {
        final CreditsMessageDto request = JsonTool.jsonToObject(message.getBizParams(), CreditsMessageDto.class);
        Object http = "post".equals(request.getHttpType()) ? AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams()) : new HttpGet(request.getHttpUrl());
        HttpRequestLog.logUrl("[action addCredits] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [url " + request.getHttpUrl() + "]");
        this.httpAsyncClientPool.submit(request.getAppId(), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                CreditsCallbackMessage resp = new CreditsCallbackMessage();
                try {
                    resp.setCallbackType("completed");
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    resp.setMessage(HttpRequestLog.subBody(body));
                }
                catch (Exception e) {
                    LOG.error("toDeveloper completed", (Throwable)e);
                }
                finally {
                    AddCreditsToDeveloper.this.finallyBlock(message, request, resp);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                LOG.error("toDeveloper failed bizId:" + request.getRelationId() + " bizType:" + request.getRelationType(), (Throwable)ex);
                CreditsCallbackMessage resp = new CreditsCallbackMessage();
                try {
                    resp.setCallbackType("failed");
                    resp.setMessage(ex.getClass().getName() + ":" + ex.getMessage());
                }
                catch (Exception e) {
                    LOG.error("toDeveloper failed", (Throwable)e);
                }
                finally {
                    AddCreditsToDeveloper.this.finallyBlock(message, request, resp);
                }
            }

            public void cancelled() {
                CreditsCallbackMessage resp = new CreditsCallbackMessage();
                resp.setCallbackType("failed");
                resp.setMessage("http cancelled");
                AddCreditsToDeveloper.this.finallyBlock(message, request, resp);
            }
        });
    }

    public void finallyBlock(HttpMessageDO message, CreditsMessageDto req, CreditsCallbackMessage resp) {
        HttpRequestLog.logUrl("[action addCredits] [tag response] [bizId " + req.getRelationId() + "] [type " + req.getRelationType() + "] [callback " + resp.getCallbackType() + "] [body " + resp.getMessage() + "]");
        if (this.nextRetry(message, resp)) {
            return;
        }
        try {
            resp.setRelationId(req.getRelationId());
            resp.setRelationType(req.getRelationType());
            resp.setParams(req.getParams());
            resp.setAppId(req.getAppId());
            resp.setConsumerId(req.getConsumerId());
            resp.setHttpUrl(req.getHttpUrl());
            String body = JsonTool.objectToJson(resp);
            String callbackTopic = req.getCallbackTopic();
            String callbackTag = req.getCallbackTag();
            String callbackKey = req.getCallbackKey();
            if (StringUtils.isEmpty((String)callbackTag) && StringUtils.isEmpty((String)callbackKey)) {
                this.messageService.sendMsg(callbackTopic, body);
            } else {
                this.messageService.sendMsg(callbackTopic, callbackTag, callbackKey, body);
            }
        }
        catch (Exception e) {
            LOG.error("credits callback: bizId:" + req.getRelationId() + " bizType:" + req.getRelationType(), (Throwable)e);
        }
    }

    public boolean nextRetry(HttpMessageDO message, CreditsCallbackMessage resp) {
        try {
            if (this.isSuccess(resp)) {
                this.httpMessageDAO.delete(message.getId());
                return false;
            }
            if (message.getNumber() >= this.httpRetryRulesService.getRetryNumber(message)) {
                this.httpMessageDAO.delete(message.getId());
                return false;
            }
            this.httpRetryRulesService.updateNextTime(message);
            return true;
        }
        catch (Exception e) {
            LOG.error("nextRetry", (Throwable)e);
            return false;
        }
    }

    public boolean isSuccess(CreditsCallbackMessage resp) {
        try {
            String body;
            return "completed".equals(resp.getCallbackType()) && ((body = resp.getMessage().toLowerCase()).contains("ok") || body.contains("success"));
        }
        catch (Exception e) {
            LOG.error("isSuccess", (Throwable)e);
            return true;
        }
    }
}

