/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MogujieApi {
    private static Logger log = LoggerFactory.getLogger(MogujieApi.class);
    private String mogujieAppKey = "100429";
    private String mogujieAppSecert = "0CE1E6E0C179AAD734E7FF8B65E24C42";
    private String mogujieMethodCredits = "mogujie.member.modou.freeze.initiate";
    private String mogujieMethodNotify = "mogujie.member.modou.freeze.notify";
    private String mogujieFormat = "json";
    private String mogujieMarketItemKey = "DUIBA_FREEZE";
    private String mogujieSendModouMarketItemKey = "DUIBA_REWARD_SEND";
    private String mogujieMethodSend = "mogujie.member.modou.notice.send";
    @Autowired
    private CustomService customService;

    public CreditsMessage getMogujieRequestCredits(CreditsMessage request) {
        try {
            String url = request.getHttpUrl();
            String host = url.substring(0, url.indexOf(63));
            String params = url.substring(url.indexOf(63) + 1, url.length());
            Map<String, String> crediMap = AssembleTool.getUrlParams(params);
            Long orderNum = this.customService.getLongOrderNum(crediMap.get("orderNum"));
            HashMap<String, String> mogujieParams = new HashMap<String, String>();
            mogujieParams.put("app_key", this.mogujieAppKey);
            mogujieParams.put("method", this.mogujieMethodCredits);
            mogujieParams.put("format", this.mogujieFormat);
            mogujieParams.put("timestamp", String.valueOf(new Date().getTime()));
            mogujieParams.put("access_token", crediMap.get("transfer"));
            HashMap<String, Object> credits = new HashMap<String, Object>();
            credits.put("businessId", orderNum);
            credits.put("marketItemKey", this.mogujieMarketItemKey);
            credits.put("coinAmount", crediMap.get("credits"));
            credits.put("token", crediMap.get("uid"));
            mogujieParams.put("openApiInitiateFreezeCoinParam", JSONObject.toJSONString(credits));
            mogujieParams.put("sign", this.sign(this.mogujieAppSecert, mogujieParams));
            String requestUrl = AssembleTool.assembleUrl(host, mogujieParams);
            request.setHttpUrl(requestUrl);
            return request;
        }
        catch (Exception e) {
            log.error("getMogujieRequestCreditsURL:", (Throwable)e);
            return request;
        }
    }

    public String getMogujieResponseCredis(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            log.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        String code = json.getString("code");
        if ("0000000".equals(code)) {
            duibaDoc.put("status", "ok");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", json.getString("msg"));
        duibaDoc.put("bizId", json.getString("bizId"));
        duibaDoc.put("credits", json.getString("coinBalance"));
        return JsonTool.objectToJson(duibaDoc);
    }

    public String getMogujieRequestNotify(String url, NotifyQueueDO queue) {
        try {
            Long orderNum = this.customService.getLongOrderNum(queue.getDuibaOrderNum());
            HashMap<String, String> mogujieParams = new HashMap<String, String>();
            mogujieParams.put("app_key", this.mogujieAppKey);
            mogujieParams.put("method", this.mogujieMethodNotify);
            mogujieParams.put("format", this.mogujieFormat);
            mogujieParams.put("timestamp", String.valueOf(new Date().getTime()));
            mogujieParams.put("access_token", queue.getTransfer());
            HashMap<String, Object> notify = new HashMap<String, Object>();
            notify.put("businessId", orderNum);
            notify.put("marketItemKey", this.mogujieMarketItemKey);
            notify.put("success", queue.getResult());
            notify.put("errorMessage", queue.getError4developer());
            notify.put("bizId", queue.getDeveloperBizId());
            notify.put("token", queue.getPartnerUserId());
            mogujieParams.put("openApiFreezeCoinParam", JSONObject.toJSONString(notify));
            mogujieParams.put("sign", this.sign(this.mogujieAppSecert, mogujieParams));
            return AssembleTool.assembleUrl(url, mogujieParams);
        }
        catch (CodeException e) {
            log.error("getMogujieRequestNotify", (Throwable)e);
            return null;
        }
    }

    public String getMogujieResponseNotify(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            log.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        String code = json.getString("code");
        if ("0000000".equals(code)) {
            return "ok";
        }
        return body;
    }

    private String sign(String secret, Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder string = new StringBuilder();
        string.append(secret);
        for (String key : keys) {
            string.append(key).append(params.get(key));
        }
        string.append(secret);
        return DigestUtils.md5Hex((String)string.toString()).toUpperCase();
    }

    public CreditsMessageDto getMogujieRequestAddCredits(CreditsMessageDto req) {
        try {
            String url = req.getHttpUrl();
            String host = url.substring(0, url.indexOf(63));
            String params = url.substring(url.indexOf(63) + 1, url.length());
            Map<String, String> crediMap = AssembleTool.getUrlParams(params);
            Long orderNum = this.customService.getLongOrderNum(crediMap.get("orderNum"));
            HashMap<String, String> mogujieParams = new HashMap<String, String>();
            mogujieParams.put("app_key", this.mogujieAppKey);
            mogujieParams.put("method", this.mogujieMethodSend);
            mogujieParams.put("format", this.mogujieFormat);
            mogujieParams.put("timestamp", String.valueOf(new Date().getTime()));
            mogujieParams.put("access_token", crediMap.get("transfer"));
            HashMap<String, Object> credits = new HashMap<String, Object>();
            credits.put("businessId", orderNum);
            credits.put("marketItemKey", this.mogujieSendModouMarketItemKey);
            credits.put("coinAmount", crediMap.get("credits"));
            mogujieParams.put("baseOpenApiCoinParam", JSONObject.toJSONString(credits));
            mogujieParams.put("sign", this.sign(this.mogujieAppSecert, mogujieParams));
            String requestUrl = AssembleTool.assembleUrl(host, mogujieParams);
            req.setHttpUrl(requestUrl);
            return req;
        }
        catch (Exception e) {
            log.error("getMogujieAddRequestCreditsURL:", (Throwable)e);
            return req;
        }
    }

    public String getMogujieResponseAddCredis(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            log.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        String code = json.getString("code");
        if ("0000000".equals(code)) {
            duibaDoc.put("status", "ok");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", json.getString("msg"));
        duibaDoc.put("bizId", json.getString("bizId"));
        duibaDoc.put("credits", json.getString("coinBalance"));
        return JsonTool.objectToJson(duibaDoc);
    }

    public SupplierRequest getMogujieRequestSendCredits(SupplierRequest request) {
        try {
            String url = request.getHttpUrl();
            String host = url.substring(0, url.indexOf(63));
            String params = url.substring(url.indexOf(63) + 1, url.length());
            Map<String, String> crediMap = AssembleTool.getUrlParams(params);
            String keys = crediMap.get("params");
            JSONObject json = JSON.parseObject((String)keys);
            if (!"modou".equals(json.get((Object)"prizeType"))) {
                return request;
            }
            Long orderNum = this.customService.getLongOrderNum(crediMap.get("orderNum"));
            HashMap<String, String> mogujieParams = new HashMap<String, String>();
            mogujieParams.put("app_key", this.mogujieAppKey);
            mogujieParams.put("method", this.mogujieMethodCredits);
            mogujieParams.put("format", this.mogujieFormat);
            mogujieParams.put("timestamp", String.valueOf(new Date().getTime()));
            mogujieParams.put("access_token", request.getParams().get("transfer"));
            HashMap<String, Object> credits = new HashMap<String, Object>();
            credits.put("businessId", orderNum);
            credits.put("marketItemKey", this.mogujieMarketItemKey);
            credits.put("coinAmount", json.get((Object)"num"));
            credits.put("token", crediMap.get("uid"));
            mogujieParams.put("openApiInitiateFreezeCoinParam", JSONObject.toJSONString(credits));
            mogujieParams.put("sign", this.sign(this.mogujieAppSecert, mogujieParams));
            String requestUrl = AssembleTool.assembleUrl(host, mogujieParams);
            request.setHttpUrl(requestUrl);
            return request;
        }
        catch (Exception e) {
            log.error("getMogujieRequestCreditsURL:", (Throwable)e);
            return request;
        }
    }

    public String getVirtualRespone(SupplierRequest request, String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            log.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        String code = json.getString("code");
        if ("0000000".equals(code)) {
            duibaDoc.put("status", "success");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", json.getString("msg"));
        duibaDoc.put("supplierBizId", json.getString("bizId"));
        duibaDoc.put("credits", json.getString("coinBalance"));
        return JsonTool.objectToJson(duibaDoc);
    }
}

